package net.polyv.live.v1.entity.interact;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 手动结束问卷请求实体
 * @author: jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("手动结束问卷请求实体")
public class LiveQuestionnaireEndRequest extends LiveCommonRequest {
    
    /**
     * 频道号，多个频道用英文逗号分隔，如：100000,100001
     */
    @ApiModelProperty(name = "channelIds", value = "频道号，多个频道用英文逗号分隔，如：100000,100001", required = true)
    @NotNull(message = "属性channelIds不能为空")
    private String channelIds;
}
