package net.polyv.live.v1.entity.chat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 管理员发送聊天信息请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("管理员发送聊天信息请求实体")
public class LiveSendAdminMessageRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 发送的文本消息，文本消息和图片消息必传一个，最长为2000字符
     */
    @ApiModelProperty(name = "msg", value = "发送的文本消息，文本消息和图片消息必传一个，最长为2000字符", required = false)
    private String msg;
    
    /**
     * 发送的图片消息地址，url不支持带参数。文本消息和图片消息必传一个 发送图片消息时，设置的昵称和头像暂不生效
     */
    @ApiModelProperty(name = "imgUrl", value = "发送的图片消息地址，url不支持带参数。文本消息和图片消息必传一个 发送图片消息时，设置的昵称和头像暂不生效", required =
            false)
    private String imgUrl;
    
    /**
     * 管理员头像，url不支持带参数。
     */
    @ApiModelProperty(name = "pic", value = "管理员头像，url不支持带参数。", required = true)
    @NotNull(message = "属性pic不能为空")
    private String pic;
    
    /**
     * 昵称，最大为8个长度，超出会被截断
     */
    @ApiModelProperty(name = "nickName", value = "昵称，最大为8个长度，超出会被截断", required = true)
    @NotNull(message = "属性nickName不能为空")
    private String nickName;
    
    /**
     * 管理员索引，可以指定多个管理员发送消息，默认只有一个管理员
     */
    @ApiModelProperty(name = "adminIndex", value = "管理员索引，可以指定多个管理员发送消息，默认只有一个管理员", required = false)
    private Integer adminIndex;
    
    /**
     * 头衔，最大为4个长度，超出会被截断，不传参数则表示无头衔
     */
    @ApiModelProperty(name = "actor", value = "头衔，最大为4个长度，超出会被截断，不传参数则表示无头衔", required = false)
    private String actor;
    
    /**
     * 当频道开启审核后消息是否需要经过审核，默认为N Y：不需要 N：需要
     */
    @ApiModelProperty(name = "freeReview", value = "当频道开启审核后消息是否需要经过审核，默认为N Y：不需要 N：需要", required = false)
    private String freeReview;
    
    /**
     * 接口版本，目前可选版本(3.2)，不同的版本返回数据会有细微差异，详情查看响应示例
     */
//    @ApiModelProperty(name = "apiVersion", value = "接口版本，目前可选版本(3.2)，不同的版本返回数据会有细微差异，详情查看响应示例", required = true)
    @NotNull(message = "属性apiVersion不能为空")
    @ApiModelProperty(hidden = true, required = true)
    private String apiVersion = "3.2";
    
}