package net.polyv.live.v1.entity.channel.state;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 结束伪直播请求实体
 * @author sadboy
 */
@Data
@Accessors(chain = true)
@ApiModel("结束伪直播请求实体")
@EqualsAndHashCode(callSuper = true)
public class LiveEndDiskPushRequest extends LiveCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 伪直播id,不传则结束当前时间直播中的伪直播
     */
    @ApiModelProperty(name = "diskVideoId", value = "伪直播id,不传则结束当前时间直播中的伪直播", required = false)
    private String diskVideoId;
    
}
