/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.common.v1.util;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.entity.AccountInfo;
import net.polyv.common.v1.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    private FileUtil() {
    }

    public static String readFile(String filepath) throws IOException {
        Path path = Paths.get(filepath, new String[0]);
        byte[] data = Files.readAllBytes(path);
        return new String(data, Constant.UTF8_CHARSET);
    }

    public static AccountInfo readConfigFromFile(String path) {
        if (StringUtils.isBlank(path)) {
            path = "/data/password/password.txt";
        }
        String accountInfo = null;
        try {
            accountInfo = FileUtil.readFile(path);
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u6587\u4ef6\u9519\u8bef\uff0c\u6587\u4ef6\u8def\u5f84 {}", (Object)path, (Object)e);
            return null;
        }
        if (StringUtils.isNotBlank(accountInfo)) {
            return JSON.parseObject(accountInfo, AccountInfo.class);
        }
        log.error("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff0c\u6587\u4ef6\u8def\u5f84 {}", (Object)path);
        return null;
    }

    public static void writeFile(byte[] bytes, String filepath) throws IOException {
        Path path = Paths.get(filepath, new String[0]);
        Files.write(path, bytes, new OpenOption[0]);
    }

    public static String getExtension(String filename) {
        if (filename == null) {
            return "";
        }
        int extensionPos = filename.lastIndexOf(46);
        if (extensionPos < 0) {
            return "";
        }
        return filename.substring(extensionPos + 1);
    }
}

