package net.polyv.live.v2.entity.user.template;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询默认模板回放设置响应实体
 * @author liyongxuan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询默认模板回放设置响应实体")
public class LiveGetTemplatePlaybackSettingResponse {
    
    /**
     * 回放开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "playbackEnabled", value = "回放开关 Y：开启 N：关闭", required = false)
    private String playbackEnabled;
    
    /**
     * 观看页回放方式 single：单个视频 list：列表回放
     */
    @ApiModelProperty(name = "type", value = "观看页回放方式 single：单个视频 list：列表回放", required = false)
    private String type;
    
    /**
     * 回放视频来源 record：暂存 playback：回放列表 vod：点播列表
     */
    @ApiModelProperty(name = "origin", value = "回放视频来源 record：暂存 playback：回放列表 vod：点播列表", required = false)
    private String origin;
    
    /**
     * 章节开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "sectionEnabled", value = "章节开关 Y：开启 N：关闭", required = false)
    private String sectionEnabled;
    
    /**
     * 聊天回放开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "chatPlaybackEnabled", value = "聊天回放开关 Y：开启 N：关闭", required = false)
    private String chatPlaybackEnabled;
    
}