package net.polyv.live.v2.entity.chat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotBlank;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 查询频道虚拟人数详情请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询频道虚拟人数详情请求实体")
public class LiveGetRobotStatsRequest extends LiveCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotBlank(message = "属性channelId不能为空")
    private String channelId;
    
}