package net.polyv.live.v2.entity.channel.viewdata;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 查询频道连麦详情数据请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询频道连麦详情数据请求实体")
public class LiveListLinkMicDetailRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 开始日期，格式：yyyy-MM-dd，如2020-10-01，时间范围不能超过30天
     */
    @ApiModelProperty(name = "startDate", value = "开始日期，格式：yyyy-MM-dd，如2020-10-01，时间范围不能超过30天", required = true)
    @NotNull(message = "属性startDate不能为空")
    @JSONField(format = "yyyy-MM-dd")
    private Date startDate;
    
    /**
     * 结束日期，格式：yyyy-MM-dd，如2020-10-01，时间范围不能超过30天
     */
    @ApiModelProperty(name = "endDate", value = "结束日期，格式：yyyy-MM-dd，如2020-10-01，时间范围不能超过30天", required = true)
    @NotNull(message = "属性endDate不能为空")
    @JSONField(format = "yyyy-MM-dd")
    private Date endDate;
    
    /**
     * 当前页码，默认为1
     */
    @ApiModelProperty(name = "page", value = "当前页码，默认为1", required = false)
    private Integer page;
    
    /**
     * 每页数据大小，默认500条，最大5000条，超过5000条可以分多批拉取，每次page加1，直到返回列表contents为空为止
     */
    @ApiModelProperty(name = "pageSize", value = "每页数据大小，默认500条，最大5000条，超过5000条可以分多批拉取，每次page加1，直到返回列表contents为空为止",
            required = false)
    private Integer pageSize;
    
}