package net.polyv.live.v2.entity.channel.viewdata;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 查询时间范围内频道直播观看详情数据请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询时间范围内频道直播观看详情数据请求实体")
public class LiveDailySummaryRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 开始日期，格式：yyyy-MM-dd
     */
    @ApiModelProperty(name = "startDay", value = "开始日期，格式：yyyy-MM-dd", required = true)
    @NotNull(message = "属性startDay不能为空")
    @JSONField(format = "yyyy-MM-dd")
    private Date startDay;
    
    /**
     * 结束日期，格式：yyyy-MM-dd
     */
    @ApiModelProperty(name = "endDay", value = "结束日期，格式：yyyy-MM-dd", required = true)
    @NotNull(message = "属性endDay不能为空")
    @JSONField(format = "yyyy-MM-dd")
    private Date endDay;
    
}