package net.polyv.live.v2.entity.channel.statistics;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 查询红包派发数据统计响应实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询红包派发数据统计响应实体")
public class LiveGetRedPackStatsResponse extends LivePageCommonResponse {
    
    /**
     * 当前页内容
     */
    @ApiModelProperty(name = "contents", value = "当前页内容", required = false)
    private List<LiveGetRedPackStatsResponse.RedPackStats> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("当前页内容")
    public static class RedPackStats {
        
        /**
         * 红包ID
         */
        @ApiModelProperty(name = "redPackId", value = "红包ID", required = false)
        private String redPackId;
        
        /**
         * 用户微信OPENID
         */
        @ApiModelProperty(name = "userId", value = "用户微信OPENID", required = false)
        private String userId;
        
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 昵称
         */
        @ApiModelProperty(name = "nickName", value = "昵称", required = false)
        private String nickName;
        
        /**
         * 红包金额
         */
        @ApiModelProperty(name = "amount", value = "红包金额", required = false)
        private Float amount;
        
        /**
         * 红包余额
         */
        @ApiModelProperty(name = "balance", value = "红包余额", required = false)
        private Float balance;
        
        /**
         * 分配方式名称： 随机分配红包 平均分配红包
         */
        @ApiModelProperty(name = "allotType", value = "分配方式名称： 随机分配红包 平均分配红包", required = false)
        private String allotType;
        
        /**
         * 创建时间，13位毫秒级时间戳
         */
        @ApiModelProperty(name = "createdTime", value = "创建时间，13位毫秒级时间戳", required = false)
        private Date createdTime;
        
        /**
         * 状态名称： 进行中 已结束 退款中 已退款
         */
        @ApiModelProperty(name = "status", value = "状态名称： 进行中 已结束 退款中 已退款", required = false)
        private String status;
        
        /**
         * 红包类型名称 红包雨 口令红包 普通红包
         */
        @ApiModelProperty(name = "redPackType", value = "红包类型名称 红包雨 口令红包 普通红包", required = false)
        private String redPackType;
        
        /**
         * 领取用户列表
         */
        @ApiModelProperty(name = "redPackReceiveList", value = "领取用户列表", required = false)
        private List<LiveGetRedPackStatsResponse.ReceiveList> redPackReceiveList;
    }
    
    @Data
    @Accessors(chain = true)
    @ApiModel("领取用户列表")
    public static class ReceiveList {
        
        /**
         * 红包ID
         */
        @ApiModelProperty(name = "redPackId", value = "红包ID", required = false)
        private String redPackId;
        
        /**
         * 用户微信OPENID
         */
        @ApiModelProperty(name = "userId", value = "用户微信OPENID", required = false)
        private String userId;
        
        /**
         * 昵称
         */
        @ApiModelProperty(name = "nickName", value = "昵称", required = false)
        private String nickName;
        
        /**
         * 头像
         */
        @ApiModelProperty(name = "avatar", value = "头像", required = false)
        private String avatar;
        
        /**
         * 领取金额（小数点后两位）
         */
        @ApiModelProperty(name = "amount", value = "领取金额（小数点后两位）", required = false)
        private Float amount;
        
        /**
         * 领取时间
         */
        @ApiModelProperty(name = "createdTime", value = "领取时间", required = false)
        private Date createdTime;
    }
}