package net.polyv.live.v2.entity.channel.playback;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询多个频道回放列表响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询多个频道回放列表响应实体")
public class LiveGetPlaybackListResponse {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = false)
    private String channelId;
    
    /**
     * 观看回放功能开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "playBackEnabled", value = "观看回放功能开关 Y：开启 N：关闭", required = false)
    private String playBackEnabled;
    
    /**
     * 回放来源 record：暂存 playback：回放列表 vod：点播列表
     */
    @ApiModelProperty(name = "origin", value = "回放来源 record：暂存 playback：回放列表 vod：点播列表", required = false)
    private String origin;
    
    /**
     * 回放方式 single：单个视频回放 list：列表回放
     */
    @ApiModelProperty(name = "type", value = "回放方式 single：单个视频回放 list：列表回放", required = false)
    private String type;
    
    /**
     * 视频列表
     */
    @ApiModelProperty(name = "videoList", value = "视频列表", required = false)
    private List<LiveGetPlaybackListResponse.PlaybackVideoList> videoList;
    
    /**
     * 是否开启全局设置 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "globalSettingEnabled", value = "是否开启全局设置 Y：开启 N：关闭", required = false)
    private String globalSettingEnabled;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("视频列表，回放方式为单个视频时只会返回一个视频，列表回放时返回前10个视频（按时间倒序，和直播后台一致），回放开关关闭时也会返回视频列表")
    public static class PlaybackVideoList {
        
        /**
         * 直播系统生成的id （回放来源为回放列表或点播列表有值）
         */
        @ApiModelProperty(name = "videoId", value = "直播系统生成的id （回放来源为回放列表或点播列表有值）", required = false)
        private String videoId;
        
        /**
         * 点播视频videoPoolId （回放来源为回放列表或点播列表有值）
         */
        @ApiModelProperty(name = "videoPoolId", value = "点播视频videoPoolId （回放来源为回放列表或点播列表有值）", required = false)
        private String videoPoolId;
        
        /**
         * 回放视频转存前的暂存文件ID（回放来源为暂存时有值）
         */
        @ApiModelProperty(name = "fileId", value = "回放视频转存前的暂存文件ID（回放来源为暂存时有值）", required = false)
        private String fileId;
        
        /**
         * 视频时长，格式为HH:mm:ss
         */
        @ApiModelProperty(name = "duration", value = "视频时长，格式为HH:mm:ss", required = false)
        private String duration;
        
        /**
         * 视频名称
         */
        @ApiModelProperty(name = "name", value = "视频名称", required = false)
        private String name;
    }
}