package net.polyv.live.v2.entity.channel.playback;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 裁剪录制文件请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("裁剪录制文件请求实体")
public class LiveClipRecordFileRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 文件ID【可通过查询频道录制视频信息获取】
     */
    @ApiModelProperty(name = "fileId", value = "文件ID【可通过查询频道录制视频信息获取】", required = true)
    @NotNull(message = "属性fileId不能为空")
    private String fileId;
    
    /**
     * 要裁剪移除的时间区间 传入格式要求： （1）start、end值是单位为秒的数值，格式为：[{"start":xx, "end":xx},{"start":xx, "end":xx}]
     * （2）多个区间请按照时间顺序从小到大排列 （3）时间区间不允许重叠 （4）时间区间不得超过100个限制 【示例：要裁剪移除的是第1s到第14s，以及第25s到第30s的区间，则传入的字符串为 [{"start":1,
     * "end":14},{"start":25, "end":30}] 】 误差说明： （1）裁剪区间存在一定的时间误差 （2）误差原因：回放默认为m3u8格式裁剪，由于m3u8的视频裁剪是精确到每片ts
     * ，所以裁剪时会判断裁剪要移除的时间区间所包含的ts片，进行裁剪移除，如需更精准的裁剪，可联系保利威客服人员开通mp4裁剪
     */
    @ApiModelProperty(name = "deleteTimeFrame", value = "要裁剪移除的时间区间 传入格式要求： （1）start、end值是单位为秒的数值，格式为：[{\"start\":xx," +
            " \"end\":xx},{\"start\":xx, \"end\":xx}] （2）多个区间请按照时间顺序从小到大排列 （3）时间区间不允许重叠 （4）时间区间不得超过100个限制 " +
            "【示例：要裁剪移除的是第1s到第14s，以及第25s到第30s的区间，则传入的字符串为 [{\"start\":1, \"end\":14},{\"start\":25, \"end\":30}] 】 " +
            "误差说明： （1）裁剪区间存在一定的时间误差 （2）误差原因：回放默认为m3u8格式裁剪，由于m3u8的视频裁剪是精确到每片ts，所以裁剪时会判断裁剪要移除的时间区间所包含的ts" +
            "片，进行裁剪移除，如需更精准的裁剪，可联系保利威客服人员开通mp4裁剪", required = true)
    @NotNull(message = "属性deleteTimeFrame不能为空")
    private String deleteTimeFrame;
    
    /**
     * 裁剪成功或失败回调的url
     */
    @ApiModelProperty(name = "callbackUrl", value = "裁剪成功或失败回调的url", required = false)
    private String callbackUrl;
    
    /**
     * 是否自动转存回放到点播，默认为N Y：是 N：否
     */
    @ApiModelProperty(name = "autoConvert", value = "是否自动转存回放到点播，默认为N Y：是 N：否", required = false)
    private String autoConvert;
    
    /**
     * 裁剪后文件名
     */
    @ApiModelProperty(name = "fileName", value = "裁剪后文件名", required = false)
    private String fileName;
    
}