package net.polyv.live.v2.entity.channel.distribute;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 批量删除分发地址请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("批量删除分发地址请求实体")
public class LiveChannelDistributeDeleteRequest extends LiveCommonRequest {
    
    /**
     * 频道ID
     */
    @ApiModelProperty(name = "channelId", value = "频道ID", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 分发ID，以英文逗号分割
     */
    @ApiModelProperty(name = "distributeIds", value = "分发ID，以英文逗号分割", required = true)
    @NotNull(message = "属性distributeIds不能为空")
    private String distributeIds;
    
}