package net.polyv.live.v2.entity.channel.account;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改全局回调设置请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改全局回调设置请求实体")
public class LiveUpdateUserCallbackRequest extends LiveCommonRequest {
    
    /**
     * 录制生成回调URL
     */
    @ApiModelProperty(name = "recordCallbackUrl", value = "录制生成回调URL", required = false)
    private String recordCallbackUrl;
    
    /**
     * 回调录制文件内容 all：全部回放视频 last：最终回放视频
     */
    @ApiModelProperty(name = "recordFileCallBackType", value = "回调录制文件内容 all：全部回放视频 last：最终回放视频", required = false)
    private String recordFileCallBackType;
    
    /**
     * 回调文件类型 m3u8：m3u8文件 mp4：mp4文件 m3u8,mp4：m3u8和mp4文件
     */
    @ApiModelProperty(name = "recordCallbackVideoType", value = "回调文件类型 m3u8：m3u8文件 mp4：mp4文件 m3u8,mp4：m3u8和mp4文件",
            required = false)
    private String recordCallbackVideoType;
    
    /**
     * 转存成功回调URL
     */
    @ApiModelProperty(name = "playbackCallbackUrl", value = "转存成功回调URL", required = false)
    private String playbackCallbackUrl;
    
    /**
     * 重制课件转存点播回调开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "rebirthVodCallbackEnabled", value = "重制课件转存点播回调开关 Y：开启 N：关闭", required = false)
    private String rebirthVodCallbackEnabled;
    
    /**
     * 课件重制成功回调URL
     */
    @ApiModelProperty(name = "pptRecordCallbackUrl", value = "课件重制成功回调URL", required = false)
    private String pptRecordCallbackUrl;
    
    /**
     * 直播状态改变回调URL
     */
    @ApiModelProperty(name = "streamCallbackUrl", value = "直播状态改变回调URL", required = false)
    private String streamCallbackUrl;
    
    /**
     * 频道直播间信息修改回调URL
     */
    @ApiModelProperty(name = "channelBasicUpdateCallbackUrl", value = "频道直播间信息修改回调URL", required = false)
    private String channelBasicUpdateCallbackUrl;
    
    /**
     * 直播内容审核不通过回调URL
     */
    @ApiModelProperty(name = "liveScanCallbackUrl", value = "直播内容审核不通过回调URL", required = false)
    private String liveScanCallbackUrl;
    
    /**
     * 直播回放缓存生成回调通知URL
     */
    @ApiModelProperty(name = "playbackCacheCallbackUrl", value = "直播回放缓存生成回调通知URL", required = false)
    private String playbackCacheCallbackUrl;
    
}
