package net.polyv.live.v1.service.web;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

import net.polyv.live.v1.entity.web.interact.LiveChannelDonateRequest;
import net.polyv.live.v1.entity.web.interact.LiveChannelDonateResponse;
import net.polyv.live.v2.entity.channel.web.interact.LiveGetChannelDonateRequest;
import net.polyv.live.v2.entity.channel.web.interact.LiveGetChannelDonateResponse;
import net.polyv.live.v1.entity.web.interact.LiveGetChannelWxShareRequest;
import net.polyv.live.v1.entity.web.interact.LiveGetChannelWxShareResponse;
import net.polyv.live.v1.entity.web.interact.LiveUpdateChannelCashRequest;
import net.polyv.live.v2.entity.channel.web.interact.LiveUpdateChannelDonateRequest;
import net.polyv.live.v1.entity.web.interact.LiveUpdateChannelGoodRequest;
import net.polyv.live.v1.entity.web.interact.LiveUpdateChannelWxShareRequest;
import net.polyv.live.v2.entity.channel.web.interact.cardpush.LiveCancelPushChannelCardPushRequest;
import net.polyv.live.v2.entity.channel.web.interact.cardpush.LiveCreateChannelCardPushRequest;
import net.polyv.live.v2.entity.channel.web.interact.cardpush.LiveCreateChannelCardPushResponse;
import net.polyv.live.v2.entity.channel.web.interact.cardpush.LiveDeleteChannelCardPushRequest;
import net.polyv.live.v2.entity.channel.web.interact.cardpush.LiveGetChannelCardPushRequest;
import net.polyv.live.v2.entity.channel.web.interact.cardpush.LiveGetChannelCardPushResponse;
import net.polyv.live.v2.entity.channel.web.interact.cardpush.LivePushChannelCardPushRequest;
import net.polyv.live.v2.entity.channel.web.interact.cardpush.LiveUpdateChannelCardPushRequest;
import net.polyv.live.v2.entity.channel.web.interact.share.LiveGetChannelShareRequest;
import net.polyv.live.v2.entity.channel.web.interact.share.LiveGetChannelShareResponse;
import net.polyv.live.v2.entity.channel.web.interact.share.LiveUpdateChannelShareRequest;

/**
 * @author: sadboy
 **/
public interface ILiveWebInteractService {
    
    /**
     * 设置道具打赏
     * API地址：https://dev.polyv.net/2018/liveproduct/l-api/szgkygg/ymhd/updategood/
     * @param liveUpdateChannelGoodRequest 设置道具打赏请求实体
     * @return 设置道具打赏返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateChannelGood(LiveUpdateChannelGoodRequest liveUpdateChannelGoodRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 设置现金打赏
     * API地址：https://dev.polyv.net/2018/liveproduct/l-api/szgkygg/ymhd/updatecash/
     * @param liveUpdateChannelCashRequest 设置现金打赏请求实体
     * @return 设置现金打赏返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateChannelCash(LiveUpdateChannelCashRequest liveUpdateChannelCashRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询打赏设置
     * API地址：https://dev.polyv.net/2018/liveproduct/l-api/szgkygg/ymhd/donate-get/
     * @param liveChannelDonateRequest 查询打赏设置请求实体
     * @return 查询打赏设置返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveChannelDonateResponse getChannelDonate(LiveChannelDonateRequest liveChannelDonateRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 设置频道微信分享信息
     * API地址：https://dev.polyv.net/2018/liveproduct/l-api/szgkygg/ymhd/update-weixin-share/
     * @param liveUpdateChannelWxShareRequest 设置频道微信分享信息请求实体
     * @return 设置频道微信分享信息返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateChannelWxShare(LiveUpdateChannelWxShareRequest liveUpdateChannelWxShareRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询频道微信分享信息
     * API地址：https://dev.polyv.net/2018/liveproduct/l-api/szgkygg/ymhd/get-weixin-share/
     * @param liveGetChannelWxShareRequest 查询频道微信分享信息请求实体
     * @return 查询频道微信分享信息返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveGetChannelWxShareResponse getChannelWxShare(LiveGetChannelWxShareRequest liveGetChannelWxShareRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询频道打赏设置
     * API地址：https://help.polyv.net/#/live/api/v4/user/template/getDonate
     * @param liveGetChannelDonateRequest 查询频道打赏设置请求实体
     * @return 查询频道打赏设置响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveGetChannelDonateResponse getChannelDonateV2(LiveGetChannelDonateRequest liveGetChannelDonateRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 修改频道礼物打赏设置
     * API地址：https://help.polyv.net/#/live/api/v4/channel/donate/update
     * @param liveUpdateChannelDonateRequest 修改频道礼物打赏设置请求实体
     * @return 修改频道礼物打赏设置响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateChannelDonateV2(LiveUpdateChannelDonateRequest liveUpdateChannelDonateRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询频道卡片推送
     * API地址：https://help.polyv.net/#/live/api/v4/channel/market/cardPush/get
     * @param liveGetChannelCardPushRequest 查询频道卡片推送请求实体
     * @return 查询频道卡片推送响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<LiveGetChannelCardPushResponse> getChannelCardPush(LiveGetChannelCardPushRequest liveGetChannelCardPushRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 创建频道卡片推送
     * API地址：https://help.polyv.net/#/live/api/v4/channel/market/cardPush/create
     * @param liveCreateChannelCardPushRequest 创建频道卡片推送请求实体
     * @return 创建频道卡片推送响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveCreateChannelCardPushResponse createChannelCardPush(
            LiveCreateChannelCardPushRequest liveCreateChannelCardPushRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 修改频道卡片推送
     * API地址：https://help.polyv.net/#/live/api/v4/channel/market/cardPush/update
     * @param liveUpdateChannelCardPushRequest 修改频道卡片推送请求实体
     * @return 修改频道卡片推送响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateChannelCardPush(LiveUpdateChannelCardPushRequest liveUpdateChannelCardPushRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 删除卡片推送
     * API地址：https://help.polyv.net/#/live/api/v4/channel/market/cardPush/delete
     * @param liveDeleteChannelCardPushRequest 删除卡片推送请求实体
     * @return 删除卡片推送响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean deleteChannelCardPush(LiveDeleteChannelCardPushRequest liveDeleteChannelCardPushRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 推送频道卡片
     * API地址：https://help.polyv.net/#/live/api/v4/channel/market/cardPush/push
     * @param livePushChannelCardPushRequest 推送频道卡片请求实体
     * @return 推送频道卡片响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean pushChannelCardPush(LivePushChannelCardPushRequest livePushChannelCardPushRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 取消推送卡片
     * API地址：https://help.polyv.net/#/live/api/v4/channel/market/cardPush/cancelPush
     * @param liveCancelPushChannelCardPushRequest 取消推送卡片请求实体
     * @return 取消推送卡片响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean cancelPushChannelCardPush(LiveCancelPushChannelCardPushRequest liveCancelPushChannelCardPushRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询频道微信分享信息
     * API地址：https://help.polyv.net/#/live/api/v4/channel/market/share/get
     * @param liveGetChannelShareRequest 查询频道微信分享信息请求实体
     * @return 查询频道微信分享信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveGetChannelShareResponse getChannelShare(LiveGetChannelShareRequest liveGetChannelShareRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 修改频道微信分享信息
     * API地址：https://help.polyv.net/#/live/api/v4/channel/market/share/update
     * @param liveUpdateChannelShareRequest 修改频道微信分享信息请求实体
     * @return 修改频道微信分享信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateChannelShare(LiveUpdateChannelShareRequest liveUpdateChannelShareRequest)
            throws IOException, NoSuchAlgorithmException;
}
