package net.polyv.live.v1.service.player;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.live.v1.entity.player.LiveGetAntiRecordRequest;
import net.polyv.live.v1.entity.player.LiveGetAntiRecordResponse;
import net.polyv.live.v1.entity.player.LiveSetAntiRecordRequest;
import net.polyv.live.v1.entity.player.LiveSetPlayerHeaderAdvertRequest;
import net.polyv.live.v1.entity.player.LiveSetPlayerImgRequest;
import net.polyv.live.v1.entity.player.LiveSetPlayerLogoRequest;
import net.polyv.live.v1.entity.player.LiveSetPlayerPauseAdvertRequest;
import net.polyv.live.v1.entity.player.LiveSetPlayerUrlMarqueeRequest;
import net.polyv.live.v1.entity.player.LiveSetWarmupEnableRequest;
import net.polyv.live.v1.entity.player.LiveSetWarmupVedioRequest;
import net.polyv.live.v2.entity.channel.player.LiveGetWatchFeedbackListRequest;
import net.polyv.live.v2.entity.channel.player.LiveGetWatchFeedbackListResponse;

/**
 * 直播签到管理
 * @author: thomas
 **/
public interface ILivePlayerService {
    
    /**
     * 设置播放器暖场图片，API地址：https://dev.polyv.net/2017/liveproduct/l-player/updatecoverimage/
     * @param liveSetPlayerImgRequest 设置播放器暖场图片请求实体
     * @return 响应实体
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean setPlayerImg(LiveSetPlayerImgRequest liveSetPlayerImgRequest) throws IOException, NoSuchAlgorithmException;
    
    /**
     * 设置频道的暖场设置开关，API地址：https://dev.polyv.net/2019/liveproduct/l-player/set-warmup-enabled/
     * @param liveSetWarmupEnableRequest 设置频道的暖场设置开关
     * @return 响应实体
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean setPlayerWarmupEnable(LiveSetWarmupEnableRequest liveSetWarmupEnableRequest)
            throws IOException, NoSuchAlgorithmException;
    
    
    /**
     * 设置播放器Logo，API地址：https://dev.polyv.net/2016/liveproduct/l-player/updatelogo/
     * @param liveSetWarmupEnableRequest 设置播放器Logo请求实体
     * @return 响应实体
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    
    public Boolean setPlayerLogo(LiveSetPlayerLogoRequest liveSetWarmupEnableRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 设置播放器暂停广告，API地址：https://dev.polyv.net/2018/liveproduct/l-player/updatestop/
     * @param liveSetPlayerPauseAdvertRequest 设置播放器暂停广告请求实体
     * @return 响应实体
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    public Boolean setPlayerPauseAdvert(LiveSetPlayerPauseAdvertRequest liveSetPlayerPauseAdvertRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 设置播放器片头广告，API地址：https://dev.polyv.net/2018/liveproduct/l-player/updatehead/
     * @param liveSetPlayerHeaderAdvertRequest 设置播放器片头广告请求实体
     * @return 响应实体
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    public Boolean setPlayerHeaderAdvert(LiveSetPlayerHeaderAdvertRequest liveSetPlayerHeaderAdvertRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 设置播放器暖场视频，API地址：https://dev.polyv.net/2016/liveproduct/l-player/updatewarmupflv/
     * @param liveSetWarmupVedioRequest 设置播放器暖场视频请求实体
     * @return 响应实体
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    public Boolean setPlayerWarmUpVedio(LiveSetWarmupVedioRequest liveSetWarmupVedioRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 设置播放器自定义url跑马灯
     * API地址：https://dev.polyv.net/2017/liveproduct/l-player/set-diyurl-marquee/
     * @param liveSetPlayerUrlMarqueeRequest 设置播放器自定义url跑马灯请求实体
     * @return 设置播放器自定义url跑马灯返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean setPlayerUrlMarquee(LiveSetPlayerUrlMarqueeRequest liveSetPlayerUrlMarqueeRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 设置频道防录屏信息
     * API地址：https://help.polyv.net/#/live/api/player/anti_record_setting
     * @param liveSetAntiRecordRequest 设置频道防录屏信息请求实体
     * @return 设置频道防录屏信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean setLiveAntiRecord(LiveSetAntiRecordRequest liveSetAntiRecordRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询频道防录屏信息
     * API地址：https://help.polyv.net/#/live/api/player/get_anti_record
     * @param liveGetAntiRecordRequest 查询频道防录屏信息请求实体
     * @return 查询频道防录屏信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveGetAntiRecordResponse getLiveAntiRecord(LiveGetAntiRecordRequest liveGetAntiRecordRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询投诉反馈
     * API地址：https://help.polyv.net/#/live/api/player/watch/get_watch_feedback_list
     * @param liveGetWatchFeedbackListRequest 查询投诉反馈请求实体
     * @return 查询投诉反馈响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveGetWatchFeedbackListResponse getWatchFeedbackList(
            LiveGetWatchFeedbackListRequest liveGetWatchFeedbackListRequest)
            throws IOException, NoSuchAlgorithmException;
}
