package net.polyv.live.v1.service.chat;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

import net.polyv.live.v1.entity.chat.LiveBadWordRequest;
import net.polyv.live.v1.entity.chat.LiveBadWordResponse;
import net.polyv.live.v1.entity.chat.LiveChatBannedIPRequest;
import net.polyv.live.v1.entity.chat.LiveChatDelSingleMsgRequest;
import net.polyv.live.v1.entity.chat.LiveCleanChannelAllMsgRequest;
import net.polyv.live.v1.entity.chat.LiveDelBannedDataRequest;
import net.polyv.live.v1.entity.chat.LiveGetAccountBadWordRequest;
import net.polyv.live.v1.entity.chat.LiveGetBadwordIPRequest;
import net.polyv.live.v1.entity.chat.LiveGetBannedListRequest;
import net.polyv.live.v1.entity.chat.LiveGetChatAdminDataRequest;
import net.polyv.live.v1.entity.chat.LiveGetChatAdminDataResponse;
import net.polyv.live.v1.entity.chat.LiveGetConsultingRecordRequest;
import net.polyv.live.v1.entity.chat.LiveGetConsultingRecordResponse;
import net.polyv.live.v1.entity.chat.LiveGetHistoryChatMsgRequest;
import net.polyv.live.v1.entity.chat.LiveGetHistoryChatMsgResponse;
import net.polyv.live.v1.entity.chat.LiveGetMessageListRequest;
import net.polyv.live.v1.entity.chat.LiveGetMessageListResponse;
import net.polyv.live.v1.entity.chat.LiveGetQuestionStatisticalRequest;
import net.polyv.live.v1.entity.chat.LiveGetQuestionStatisticalResponse;
import net.polyv.live.v1.entity.chat.LiveKickedListRequest;
import net.polyv.live.v1.entity.chat.LiveKickedListResponse;
import net.polyv.live.v1.entity.chat.LiveSendAdminMessageRequest;
import net.polyv.live.v1.entity.chat.LiveSendAdminMessageResponse;
import net.polyv.live.v1.entity.chat.LiveSendChannelChatRequest;
import net.polyv.live.v1.entity.chat.LiveSendChatMsgRequest;
import net.polyv.live.v1.entity.chat.LiveSendChatMsgResponse;
import net.polyv.live.v1.entity.chat.LiveSendCustomChatRequest;
import net.polyv.live.v1.entity.chat.LiveSetChatAdminDataRequest;
import net.polyv.live.v1.entity.chat.LiveSetTeacherDataRequest;
import net.polyv.live.v2.entity.chat.LiveDeleteUserBadwordRequest;
import net.polyv.live.v2.entity.chat.LiveGetRobotSettingRequest;
import net.polyv.live.v2.entity.chat.LiveGetRobotSettingResponse;
import net.polyv.live.v2.entity.chat.LiveGetRobotStatsRequest;
import net.polyv.live.v2.entity.chat.LiveGetRobotStatsResponse;
import net.polyv.live.v2.entity.chat.LiveGetUserBannedListRequest;
import net.polyv.live.v2.entity.chat.LiveGetUserBannedListResponse;
import net.polyv.live.v2.entity.chat.LivePauseRobotRequest;
import net.polyv.live.v2.entity.chat.LiveSendCustomMessageRequest;
import net.polyv.live.v2.entity.chat.LiveUpdateBannedUserRequest;
import net.polyv.live.v2.entity.chat.LiveUpdateRobotSettingRequest;
import net.polyv.live.v2.entity.chat.LiveUpdateUserBannedViewerRequest;

/**
 * 直播签到管理
 * @author: thomas
 **/
public interface ILiveChatRoomService {
    
    /**
     * 通过HTTP接口发送聊天消息请求实体，API地址：https://dev.polyv.net/2019/liveproduct/zblts/send-admin-msg/
     * @param liveSendChatMsgRequest 查询签到结果请求实体
     * @return 响应实体
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveSendChatMsgResponse sendChatMsg(LiveSendChatMsgRequest liveSendChatMsgRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 设置讲师信息，API地址：https://dev.polyv.net/2019/liveproduct/zblts/update-channel-teacher/
     * @param liveSetTeacherDataRequest 设置讲师信息请求实体
     * @return 响应实体
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean setChannelTeacherMsg(LiveSetTeacherDataRequest liveSetTeacherDataRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 设置聊天室禁言ip，API地址：https://dev.polyv.net/2017/liveproduct/zblts/addbannedip/
     * @param liveChatBannedIPRequest 设置聊天室禁言ip请求实体
     * @return 当前账号下所有禁言IP列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<String> addBannedIP(LiveChatBannedIPRequest liveChatBannedIPRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 批量导入频道严禁词，API地址：https://dev.polyv.net/2017/liveproduct/zblts/addforbiddenwords/
     * @param liveBadWordRequest 批量导入频道严禁词请求实体
     * @return 响应实体
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveBadWordResponse addBadWord(LiveBadWordRequest liveBadWordRequest) throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询频道禁言列表，API地址：https://dev.polyv.net/2019/liveproduct/zblts/get-banned-list/
     * @param liveGetBannedListRequest 查询频道禁言列表请求实体
     * @return 当前账号下所有禁言IP列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<String> getBannedList(LiveGetBannedListRequest liveGetBannedListRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询频道踢人列表，API地址：https://dev.polyv.net/2019/liveproduct/zblts/list-kicked/
     * @param liveKickedListRequest 查询频道踢人列表请求实体
     * @return 当前账号下所有禁言IP列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<LiveKickedListResponse> getKickedList(LiveKickedListRequest liveKickedListRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 删除禁言IP/严禁词，API地址：https://dev.polyv.net/2017/liveproduct/zblts/delbanned/
     * @param liveDelBannedDataRequest 删除禁言IP/严禁词请求实体
     * @return 当前账号下所有禁言IP列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean delBanned(LiveDelBannedDataRequest liveDelBannedDataRequest) throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询频道严禁词/禁言IP列表，API地址：https://dev.polyv.net/2019/liveproduct/zblts/get-channel-badwords/
     * @param liveGetBadwordIPRequest 查询频道严禁词/禁言IP列表请求实体
     * @return 禁言IP 或者 禁言词
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<String> getChannelBadworkList(LiveGetBadwordIPRequest liveGetBadwordIPRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询账号严禁词列表，API地址：https://dev.polyv.net/2019/liveproduct/zblts/user-badword-list/
     * @param liveGetAccountBadWordRequest 查询账号严禁词列表请求实体
     * @return 禁言词列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<String> getAccountBadworkList(LiveGetAccountBadWordRequest liveGetAccountBadWordRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 删除频道聊天记录，API地址：https://dev.polyv.net/2017/liveproduct/zblts/cleanchat/
     * @param liveCleanChannelAllMsgRequest 删除频道聊天记录请求实体
     * @return 频道号
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 签名异常
     */
    Boolean cleanChannelAllMsg(LiveCleanChannelAllMsgRequest liveCleanChannelAllMsgRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询聊天室管理员信息，API地址：https://dev.polyv.net/2017/liveproduct/zblts/get-chat-admin/
     * @param liveGetChatAdminDataRequest 查询聊天室管理员信息请求实体
     * @return 频道号
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 签名异常
     */
    LiveGetChatAdminDataResponse getChatAdminData(LiveGetChatAdminDataRequest liveGetChatAdminDataRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询历史聊天信息，API地址：https://dev.polyv.net/2019/liveproduct/zblts/get-channel-badwords/
     * @param liveGetHistoryChatMsgRequest 查询历史聊天信息请求实体
     * @return 想要实体列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<LiveGetHistoryChatMsgResponse> getHistoryChatMsg(LiveGetHistoryChatMsgRequest liveGetHistoryChatMsgRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询历史聊天信息，API地址：https://help.polyv.net/index.html#/live/api/chat/message/get_message_list
     * @param liveGetMessageListRequest 查询历史聊天信息请求实体
     * @return 想要实体列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveGetMessageListResponse getPageHistoryChatMsg(LiveGetMessageListRequest liveGetMessageListRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 删除单条聊天记录，API地址：https://dev.polyv.net/2017/liveproduct/zblts/delchat/
     * @param liveChatDelSingleMsgRequest 删除单条聊天记录请求实体
     * @return 是否成功
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 签名异常
     */
    Boolean delChatSingleMsg(LiveChatDelSingleMsgRequest liveChatDelSingleMsgRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 设置聊天室管理员信息，API地址：https://dev.polyv.net/2017/liveproduct/zblts/set-chat-admin/
     * @param liveSetChatAdminDataRequest 设置聊天室管理员信息请求实体
     * @return 是否成功
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 签名异常
     */
    Boolean setChatAdminData(LiveSetChatAdminDataRequest liveSetChatAdminDataRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询咨询提问记录，API地址：https://dev.polyv.net/2018/liveproduct/zblts/getquestion/
     * @param liveGetConsultingRecordRequest 查询咨询提问记录请求实体
     * @return 实体列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<LiveGetConsultingRecordResponse> getConsultingRecord(
            LiveGetConsultingRecordRequest liveGetConsultingRecordRequest) throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询频道的问答统计结果，API地址：https://dev.polyv.net/2018/liveproduct/zblts/get-question-result/
     * @param liveGetQuestionStatisticalRequest 查询频道的问答统计结果请求实体
     * @return 想要实体列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<LiveGetQuestionStatisticalResponse> getQuestionStatistical(
            LiveGetQuestionStatisticalRequest liveGetQuestionStatisticalRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 管理员发送频道聊天信息
     * API地址：https://dev.polyv.net/2018/liveproduct/zblts/chatsendmsg/
     * @param liveSendChannelChatRequest 管理员发送频道聊天信息请求实体
     * @return 管理员发送频道聊天信息返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean sendChannelChat(LiveSendChannelChatRequest liveSendChannelChatRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 发送自定义聊天信息
     * API地址：https://dev.polyv.net/2016/liveproduct/zblts/send-chat/
     * @param liveSendCustomChatRequest 发送自定义聊天信息请求实体
     * @return 发送自定义聊天信息返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Deprecated
    Boolean sendCustomChat(LiveSendCustomChatRequest liveSendCustomChatRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 发送自定义聊天信息 兼容性升级V2修复bug
     * API地址：https://dev.polyv.net/2016/liveproduct/zblts/send-chat/
     * @param liveSendCustomChatRequest 发送自定义聊天信息请求实体
     * @return 发送自定义聊天信息返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean sendCustomChatV2(LiveSendCustomChatRequest liveSendCustomChatRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 发送自定义消息，支持是否加入到聊天消息记录
     * API地址：https://help.polyv.net/#/live/api/v4/chat/send_custom_message
     * @param liveSendCustomMessageRequest 发送自定义消息请求实体
     * @return 发送自定义消息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean sendCustomMessage(LiveSendCustomMessageRequest liveSendCustomMessageRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询频道虚拟人数设置
     * API地址：https://help.polyv.net/#/live/api/v4/chat/robot/get_robot_setting
     * @param liveGetRobotSettingRequest 查询频道虚拟人数设置请求实体
     * @return 查询频道虚拟人数设置响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveGetRobotSettingResponse getRobotSetting(LiveGetRobotSettingRequest liveGetRobotSettingRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询频道虚拟人数详情
     * API地址：https://help.polyv.net/#/live/api/v4/chat/robot/get_robot_stats
     * @param liveGetRobotStatsRequest 查询频道虚拟人数详情请求实体
     * @return 查询频道虚拟人数详情响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveGetRobotStatsResponse getRobotStats(LiveGetRobotStatsRequest liveGetRobotStatsRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 设置频道虚拟人数
     * API地址：https://help.polyv.net/#/live/api/v4/chat/robot/update_robot_setting
     * @param liveUpdateRobotSettingRequest 设置频道虚拟人数请求实体
     * @return 设置频道虚拟人数响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateRobotSetting(LiveUpdateRobotSettingRequest liveUpdateRobotSettingRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 停止频道虚拟人数
     * API地址：https://help.polyv.net/#/live/api/v4/chat/robot/pause_robot
     * @param livePauseRobotRequest 停止频道虚拟人数请求实体
     * @return 停止频道虚拟人数响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean pauseRobot(LivePauseRobotRequest livePauseRobotRequest) throws IOException, NoSuchAlgorithmException;
    
    /**
     * 删除账号严禁词
     * API地址：https://help.polyv.net/#/live/api/chat/banned/delete_user_badword
     * @param liveDeleteUserBadwordRequest 删除账号严禁词请求实体
     * @return 删除账号严禁词响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<String> deleteUserBadword(LiveDeleteUserBadwordRequest liveDeleteUserBadwordRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询账号禁言列表
     * API地址：https://help.polyv.net/#/live/api/chat/banned/get_user_banned_list
     * @param liveGetUserBannedListRequest 查询账号禁言列表请求实体
     * @return 查询账号禁言列表响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveGetUserBannedListResponse getUserBannedList(LiveGetUserBannedListRequest liveGetUserBannedListRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 禁言/解禁用户
     * API地址：https://help.polyv.net/#/live/api/chat/banned/update_banned_user
     * @param liveUpdateBannedUserRequest 禁言/解禁用户请求实体
     * @return 禁言/解禁用户响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateBannedUser(LiveUpdateBannedUserRequest liveUpdateBannedUserRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 账号设置禁言/解禁用户
     * API地址：https://help.polyv.net/#/live/api/chat/banned/update_user_banned_viewer
     * @param liveUpdateUserBannedViewerRequest 账号设置禁言/解禁用户请求实体
     * @return 账号设置禁言/解禁用户响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateUserBannedViewer(LiveUpdateUserBannedViewerRequest liveUpdateUserBannedViewerRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 管理员发送聊天信息
     * API地址：https://help.polyv.net/index.html#/live/api/chat/message/send_message
     * @param liveSendAdminMessageRequest 管理员发送聊天信息请求实体
     * @return 管理员发送聊天信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveSendAdminMessageResponse sendAdminMessage(LiveSendAdminMessageRequest liveSendAdminMessageRequest)
            throws IOException, NoSuchAlgorithmException;
}
