package net.polyv.live.v1.service.channel;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

import net.polyv.live.v1.entity.channel.advanced.LiveChannelRealtimeSubtitleLanguageRequest;
import net.polyv.live.v1.entity.channel.advanced.LiveChannelRealtimeSubtitleLanguageResponse;
import net.polyv.live.v1.entity.channel.advanced.LiveChannelRealtimeSubtitleRequest;
import net.polyv.live.v1.entity.channel.advanced.LiveChannelRealtimeSubtitleResponse;
import net.polyv.live.v1.entity.channel.advanced.LiveUpdateChannelRealtimeSubtitleRequest;

/**
 * 字幕配置管理
 * @author sadboy
 */
public interface ILiveChannelAdvancedService {
    
    /**
     * 查询频道的字幕配置
     * API地址：
     * @param req 查询频道的字幕配置请求实体
     * @return 查询频道的字幕配置响应实体
     * @throws IOException
     * @throws NoSuchAlgorithmException
     */
    LiveChannelRealtimeSubtitleResponse getConfig(LiveChannelRealtimeSubtitleRequest req)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 修改频道的字幕配置
     * API地址：
     * @param req 修改频道的字幕配置请求实体
     * @return 修改频道的字幕配置响应实体
     * @throws IOException
     * @throws NoSuchAlgorithmException
     */
    Boolean updateConfig(LiveUpdateChannelRealtimeSubtitleRequest req) throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询实时字幕语言类型枚举
     * API地址：
     * @param req 查询实时字幕语言类型枚举请求实体
     * @return 查询实时字幕语言类型枚举返回实体
     * @throws IOException
     * @throws NoSuchAlgorithmException
     */
    List<LiveChannelRealtimeSubtitleLanguageResponse> getLanguage(LiveChannelRealtimeSubtitleLanguageRequest req)
            throws IOException, NoSuchAlgorithmException;
    
}
