package net.polyv.live.v1.entity.channel.viewdata;

import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 分页查询账号直播观看详情数据响应实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("分页查询账号直播观看详情数据响应实体")
public class LiveGetChannelViewLogResponse extends LivePageCommonResponse {
    
    @ApiModelProperty(name = "contents", value = "观看详情数据列表", required = false)
    private List<LiveGetChannelViewLogResponse.ViewLogList> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("观看详情数据列表")
    public static class ViewLogList {
        
        /**
         * 表示此次播放动作的ID
         */
        @ApiModelProperty(name = "playId", value = "表示此次播放动作的ID", required = false)
        private String playId;
        
        /**
         * POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）
         */
        @ApiModelProperty(name = "userId", value = "POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）", required = false)
        private String userId;
        
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 播放时长，单位：秒
         */
        @ApiModelProperty(name = "playDuration", value = "播放时长，单位：秒", required = false)
        private Integer playDuration;
        
        /**
         * 停留时长，单位：秒
         */
        @ApiModelProperty(name = "stayDuration", value = "停留时长，单位：秒", required = false)
        private Integer stayDuration;
        
        /**
         * 流量大小，单位：bytes
         */
        @ApiModelProperty(name = "flowSize", value = "流量大小，单位：bytes", required = false)
        private Long flowSize;
        
        /**
         * 直播场次ID
         */
        @ApiModelProperty(name = "sessionId", value = "直播场次ID", required = false)
        private String sessionId;
        
        /**
         * 使用POLYV观看页的观众ID
         */
        @ApiModelProperty(name = "param1", value = "使用POLYV观看页的观众ID", required = false)
        @JSONField(name = "param1")
        private String viewerId;
        
        /**
         * 使用POLYV观看页的观众昵称
         */
        @ApiModelProperty(name = "param2", value = "使用POLYV观看页的观众昵称", required = false)
        @JSONField(name = "param2")
        private String viewerName;
        
        /**
         * 观看日志类型，默认为live vod：观看回放 live：直播
         */
        @ApiModelProperty(name = "param3", value = "观看日志类型，默认为live vod：观看回放 live：直播", required = false)
        @JSONField(name = "param3")
        private String logType;
        
        /**
         * POLYV系统参数
         */
        @ApiModelProperty(name = "param4", value = "POLYV系统参数", required = false)
        private String param4;
        
        /**
         * POLYV系统参数
         */
        @ApiModelProperty(name = "param5", value = "POLYV系统参数", required = false)
        private String param5;
        
        /**
         * IP地址
         */
        @ApiModelProperty(name = "ipAddress", value = "IP地址", required = false)
        private String ipAddress;
        
        /**
         * 国家
         */
        @ApiModelProperty(name = "country", value = "国家", required = false)
        private String country;
        
        /**
         * 省份
         */
        @ApiModelProperty(name = "province", value = "省份", required = false)
        private String province;
        
        /**
         * 城市
         */
        @ApiModelProperty(name = "city", value = "城市", required = false)
        private String city;
        
        /**
         * ISP运营商
         */
        @ApiModelProperty(name = "isp", value = "ISP运营商", required = false)
        private String isp;
        
        /**
         * 播放视频页面地址
         */
        @ApiModelProperty(name = "referer", value = "播放视频页面地址", required = false)
        private String referer;
        
        /**
         * 用户设备
         */
        @ApiModelProperty(name = "userAgent", value = "用户设备", required = false)
        private String userAgent;
        
        /**
         * 操作系统
         */
        @ApiModelProperty(name = "operatingSystem", value = "操作系统", required = false)
        private String operatingSystem;
        
        /**
         * 浏览器
         */
        @ApiModelProperty(name = "browser", value = "浏览器", required = false)
        private String browser;
        
        /**
         * 是否为移动端
         */
        @ApiModelProperty(name = "isMobile", value = "是否为移动端", required = false)
        private String isMobile;
        
        /**
         * 查询日期，格式：yyyy-MM-dd
         */
        @ApiModelProperty(name = "currentDay", value = "查询日期，格式：yyyy-MM-dd", required = false)
        @JSONField(format = "yyyy-MM-dd")
        private Date currentDay;
        
        /**
         * 日志创建日期，13位毫秒级时间戳
         */
        @ApiModelProperty(name = "createdTime", value = "日志创建日期，13位毫秒级时间戳", required = false)
        private Date createdTime;
        
        /**
         * 日志更新日期，13位毫秒级时间戳
         */
        @ApiModelProperty(name = "lastModified", value = "日志更新日期，13位毫秒级时间戳", required = false)
        private Date lastModified;
        
        /**
         * 1：无延迟观看 0：普通观看
         */
        @ApiModelProperty(name = "pType", value = "1：无延迟观看 0：普通观看", required = false)
        @JSONField(name = "ptype")
        private Integer pType;
    
        /**
         * 进入页面时间，部分情况返回为null，非特殊说明，请使用createdTime替代
         */
        @ApiModelProperty(name = "firstActiveTime", value = "进入页面时间，部分情况返回为null，非特殊说明，请使用createdTime替代", required = false)
        private Date firstActiveTime;
        
        /**
         * 退出页面时间，部分情况返回为null，非特殊说明，请使用createdTime+stayDuration替代
         */
        @ApiModelProperty(name = "lastActiveTime", value = "退出页面时间，部分情况返回为null，非特殊说明，请使用createdTime+stayDuration替代", required = false)
        private Date lastActiveTime;
        
    }
}