package net.polyv.live.v1.entity.channel.operate;

import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改频道的相关设置请求实体
 * @author: sadboy
 **/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("频道相关设置请求基本信息")
public class LiveChannelSettingRequest extends LiveCommonRequest {
    
    /**
     * 需要修改频道相关设置的频道号，例如：1938028
     */
    @ApiModelProperty(name = "channelId", value = "需要设置频道详情的频道号，例如：1938028", required = true, example = "1938028")
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 基础设置
     */
    @ApiModelProperty(name = "basicSetting", value = "基础设置", required = false)
    private BasicSetting basicSetting;
    
    /**
     * 观看条件设置
     */
    @ApiModelProperty(name = "authSettings", value = "观看条件设置", required = false)
    private List<AuthSetting> authSettings;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("基础设置")
    public static class BasicSetting {
        /**
         * 频道名称
         */
        @ApiModelProperty(name = "name", value = "频道名称", required = false)
        private String name;
        
        /**
         * 频道密码,长度不能超过16位,必须同时包含字母和数字
         */
        @ApiModelProperty(name = "channelPasswd", value = "频道密码,长度不能超过16位,必须同时包含字母和数字", required = false)
        private String channelPasswd;
        
        /**
         * 主持人名称
         */
        @ApiModelProperty(name = "publisher", value = "主持人名称", required = false)
        private String publisher;
        
        /**
         * 直播开始时间，13位时间戳，设置为0 表示关闭直播开始时间显示
         */
        @ApiModelProperty(name = "startTime", value = "直播开始时间，13位时间戳，设置为0 表示关闭直播开始时间显示", required = false)
        private Long startTime;
        
        /**
         * 累积观看数
         */
        @ApiModelProperty(name = "pageView", value = "累积观看数", required = false)
        private Integer pageView;
        
        /**
         * 点赞数
         */
        @ApiModelProperty(name = "likes", value = "点赞数", required = false)
        private Integer likes;
        
        /**
         * 封面图片地址
         */
        @ApiModelProperty(name = "coverImg", value = "封面图片地址", required = false)
        private String coverImg;
        
        /**
         * 引导图地址
         */
        @ApiModelProperty(name = "splashImg", value = "引导图地址", required = false)
        private String splashImg;
        
        /**
         * 引导页开关(Y、N)
         */
        @ApiModelProperty(name = "splashEnabled", value = "引导页开关(Y、N)", required = false)
        private String splashEnabled;
        
        /**
         * 直播介绍
         */
        @ApiModelProperty(name = "desc", value = "直播介绍", required = false)
        private String desc;
        
        /**
         * 咨询提问开关(Y、N)
         */
        @ApiModelProperty(name = "consultingMenuEnabled", value = "咨询提问开关(Y、N)", required = false)
        private String consultingMenuEnabled;
        
        /**
         * 是否限制最大观看人数(Y、N)
         */
        @ApiModelProperty(name = "maxViewerRestrict", value = "是否限制最大观看人数(Y、N)", required = false)
        private String maxViewerRestrict;
        
        /**
         * 最大在线人数
         */
        @ApiModelProperty(name = "maxViewer", value = "最大在线人数", required = false)
        private Integer maxViewer;
        
        /**
         * 频道的所属分类（分类ID可通过“获取直播分类”接口得到）
         */
        @ApiModelProperty(name = "categoryId", value = "频道的所属分类（分类ID可通过“获取直播分类”接口得到）", required = false)
        private Integer categoryId;
        
        /**
         * -1<=连麦人数<=账号的连麦人数，-1：使用账号的连麦人数，最大16人
         */
        @ApiModelProperty(name = "linkMicLimit", value = "-1<=连麦人数<=账号的连麦人数，-1：使用账号的连麦人数，最大16人", required = false)
        private Integer linkMicLimit;
        
        /**
         * 是否增加转播关联，Y：表示增加关联，N：表示取消关联 (注：需要开启频道转播功能该参数才生效)(Y、N)
         */
        @ApiModelProperty(name = "operation", value = "是否增加转播关联，Y：表示增加关联，N：表示取消关联 (注：需要开启频道转播功能该参数才生效)(Y、N)",
                required = false)
        private String operation;
        
        /**
         * 接收转播频道号，多个频道号用半角逗号,隔开(注：需要开启频道转播功能该参数才生效)
         */
        @ApiModelProperty(name = "receiveChannelIds", value = "接收转播频道号，多个频道号用半角逗号,隔开(注：需要开启频道转播功能该参数才生效)", required =
                false)
        private String receiveChannelIds;
        
        /**
         * 是否关闭弹幕功能的开关 N：表示不关闭，Y：表示关闭；
         */
        @ApiModelProperty(name = "closeBarrage", value = "是否关闭弹幕功能的开关，N：表示不关闭，Y：表示关闭；", required = false)
        @JSONField(name = "closeDanmu")
        private String closeBarrage;
        
        /**
         * 默认是否显示弹幕信息开关 Y：表示显示 N：表示不显示
         */
        @ApiModelProperty(name = "showBarrageInfoEnabled", value = "默认是否显示弹幕信息开关，Y：表示显示，N：表示不显示；", required = false)
        @JSONField(name = "showDanmuInfoEnabled")
        private String showBarrageInfoEnabled;
        
        /**
         * 是否开启无延时直播开关，为空时不对字段进行修改，直播中不能对该字段进行修改 Y：表示是 N：表示否
         */
        @ApiModelProperty(name = "pureRtcEnabled", value = "是否开启无延时直播开关，为空时不对字段进行修改，直播中不能对该字段进行修改，Y：表示是，N：表示否；",
                required = false)
        private String pureRtcEnabled;
        
        /**
         * 自定义讲师ID，32个以内ASCII码可见字符
         */
        @ApiModelProperty(name = "customTeacherId", value = "自定义讲师ID，32个以内ASCII码可见字符",
                required = false)
        private String customTeacherId;
    
        /**
         * 标签id数组，传null不修改
         */
        @ApiModelProperty(name = "labelData", value = "标签id数组，传null不修改", required = false)
        private List<String> labelData;
        
    }
    
    @Data
    @Accessors(chain = true)
    @ApiModel("观看条件设置")
    public static class AuthSetting {
        /**
         * 通用参数：主要观看条件为1，次要观看条件为2
         */
        @ApiModelProperty(name = "rank", value = "通用参数：主要观看条件为1，次要观看条件为2", required = true)
        @NotNull(message = "属性rank不能为空")
        private Integer rank;
        
        /**
         * 通用参数：是否开启，Y为开启，N为关闭
         */
        @ApiModelProperty(name = "enabled", value = "通用参数：是否开启，Y为开启，N为关闭", required = true)
        @NotNull(message = "属性enabled不能为空")
        private String enabled;
        
        /**
         * 通用参数：付费观看-pay，验证码观看-code，白名单观看-phone，登记观看-info，自定义授权观看-custom，外部授权-external,直接授权-direct
         */
        @ApiModelProperty(name = "authType", value = "通用参数：付费观看-pay，验证码观看-code，白名单观看-phone，登记观看-info，自定义授权观看-custom" +
                "，外部授权-external,直接授权-direct", required = false)
        private String authType;
        
        /**
         * 付费观看参数：欢迎语标题
         */
        @ApiModelProperty(name = "payAuthTips", value = "付费观看参数：欢迎语标题", required = false)
        private String payAuthTips;
        
        /**
         * 付费观看参数：价格，单位为元
         */
        @ApiModelProperty(name = "price", value = "付费观看参数：价格，单位为元", required = false)
        private Float price;
        
        /**
         * 付费观看参数：付费有效截止日期。当watchEndTime和validTimePeriod都为空时，表示付费永久有效
         */
        @ApiModelProperty(name = "watchEndTime", value = "付费观看参数：付费有效截止日期。当watchEndTime和validTimePeriod都为空时，表示付费永久有效"
                , required = false)
        private Date watchEndTime;
        
        /**
         * 付费观看参数：付费有效时长，单位天。当watchEndTime和validTimePeriod都为空时，表示付费永久有效
         */
        @ApiModelProperty(name = "validTimePeriod", value = "付费观看参数：付费有效时长，单位天。当watchEndTime和validTimePeriod" +
                "都为空时，表示付费永久有效", required = false)
        private Integer validTimePeriod;
        
        /**
         * 验证码观看参数：验证码
         */
        @ApiModelProperty(name = "authCode", value = "验证码观看参数：验证码", required = false)
        private String authCode;
        
        /**
         * 验证码观看参数：提示文案
         */
        @ApiModelProperty(name = "qcodeTips", value = "验证码观看参数：提示文案", required = false)
        private String qcodeTips;
        
        /**
         * 验证码观看参数：公众号二维码地址
         */
        @ApiModelProperty(name = "qcodeImg", value = "验证码观看参数：公众号二维码地址", required = false)
        private String qcodeImg;
        
        /**
         * 当authType为phone时，设置参数，非必填。提示文案
         */
        @ApiModelProperty(name = "authTips", value = "当authType为phone时，设置参数，非必填。提示文案", required = false)
        private String authTips;
        
        /**
         * 当authType为phone时，设置参数，非必填。白名单入口文案
         */
        @ApiModelProperty(name = "whiteListEntryText", value = "当authType为phone时，设置参数，非必填。白名单入口文案", required = false)
        private String whiteListEntryText;
        
        /**
         * 当authType为phone时，设置参数，非必填。白名单输入提示
         */
        @ApiModelProperty(name = "whiteListInputTips", value = "当authType为phone时，设置参数，非必填。白名单输入提示", required = false)
        private String whiteListInputTips;
        
        /**
         * 登记观看参数,上限为5个
         */
        @ApiModelProperty(name = "infoFields", value = "登记观看参数,上限为5个", required = false)
        private List<LiveChannelInitRequest.InfoField> infoFields;
        
        /**
         * 当authType为info时，设置参数，非必填。欢迎标题
         */
        @ApiModelProperty(name = "infoAuthTips", value = "当authType为info时，设置参数，非必填。欢迎标题", required = false)
        private String infoAuthTips;
        
        /**
         * 当authType为info时，设置参数，非必填。提示信息
         */
        @ApiModelProperty(name = "infoDesc", value = "当authType为info时，设置参数，非必填。提示信息", required = false)
        private String infoDesc;
        
        /**
         * 当authType为info时，设置参数，非必填。入口文本
         */
        @ApiModelProperty(name = "infoEntryText", value = "当authType为info时，设置参数，非必填。入口文本", required = false)
        private String infoEntryText;
        
        /**
         * 外部授权参数：SecretKey
         */
        @ApiModelProperty(name = "externalKey", value = "外部授权参数：SecretKey", required = false)
        private String externalKey;
        
        /**
         * 外部授权参数：自定义url
         */
        @ApiModelProperty(name = "externalUri", value = "外部授权参数：自定义url", required = false)
        private String externalUri;
        
        /**
         * 外部授权参数：跳转地址
         */
        @ApiModelProperty(name = "externalRedirectUri", value = "外部授权参数：跳转地址", required = false)
        private String externalRedirectUri;
        
        /**
         * 自定义授权参数：SecretKey
         */
        @ApiModelProperty(name = "customKey", value = "自定义授权参数：SecretKey", required = false)
        private String customKey;
        
        /**
         * 自定义授权参数：自定义url
         */
        @ApiModelProperty(name = "customUri", value = "自定义授权参数：自定义url", required = false)
        private String customUri;
        
        /**
         * 直接授权参数：直接授权SecretKey
         */
        @ApiModelProperty(name = "directKey", value = "直接授权参数：直接授权SecretKey", required = false)
        private String directKey;
        
    }
    
}
