package net.polyv.live.v2.entity.user.children;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageNumberCommonRequest;

/**
 * 查询用户子账号列表请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询用户子账号列表请求实体")
public class LiveGetUserChildrenRequest extends LivePageNumberCommonRequest {
    
    /**
     * 子账号邮箱，多个邮箱ID以,分隔，一次最多传入100个
     */
    @ApiModelProperty(name = "childEmail", value = "子账号邮箱，多个邮箱ID以,分隔，一次最多传入100个", required = false)
    private String childEmail;
    
}