package net.polyv.live.v2.entity.user.children;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询角色列表响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询角色列表响应实体")
public class LiveGetChildrenRoleListResponse {
    
    /**
     * 角色ID
     */
    @ApiModelProperty(name = "id", value = "角色ID", required = false)
    private Integer id;
    
    /**
     * 角色名称
     */
    @ApiModelProperty(name = "name", value = "角色名称", required = false)
    private String name;
    
    /**
     * 角色描述，备注
     */
    @ApiModelProperty(name = "description", value = "角色描述，备注", required = false)
    private String description;
    
    /**
     * 权限名称，多个权限名称用英文逗号”,“分割
     */
    @ApiModelProperty(name = "permissionName", value = "权限名称，多个权限名称用英文逗号”,“分割", required = false)
    private String permissionName;
    
}