package net.polyv.live.v2.entity.channel.web.interact.cardpush;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 推送频道卡片请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("推送频道卡片请求实体")
public class LivePushChannelCardPushRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 卡片推送主键ID
     */
    @ApiModelProperty(name = "cardPushId", value = "卡片推送主键ID", required = true)
    @NotNull(message = "属性cardPushId不能为空")
    private Long cardPushId;
    
}