package net.polyv.live.v2.entity.channel.viewdata;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 查询频道实时并发数据请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询频道实时并发数据请求实体")
public class LiveRealviewersRequest extends LiveCommonRequest {
    /**
     * 直播账号ID
     */
    @ApiModelProperty(name = "userId", value = "直播账号ID", required = true)
    @NotNull(message = "属性userId不能为空")
    private String userId;
    
    /**
     * 直播账号ID
     */
    @ApiModelProperty(name = "channelId", value = "直播频道ID", required = true)
    @NotNull(message = "属性直播频道ID不能为空")
    private String channelId;
    
}