package net.polyv.live.v2.entity.channel.viewdata;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 查询频道连麦详情数据响应实体
 * @author liyongxuan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询频道连麦详情数据响应实体")
public class LiveListLinkMicDetailResponse extends LivePageCommonResponse {
    
    /**
     * 当前页码，默认为1
     */
    @ApiModelProperty(name = "page", value = "当前页码，默认为1", required = false)
    private Integer page;
    
    /**
     * 查询的结果列表
     */
    @ApiModelProperty(name = "contents", value = "查询的结果列表", required = false)
    private List<LiveListLinkMicDetailResponse.MicDetail> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("查询的结果列表")
    public static class MicDetail {
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 场次号
         */
        @ApiModelProperty(name = "sessionId", value = "场次号", required = false)
        private String sessionId;
        
        /**
         * 观众ID
         */
        @ApiModelProperty(name = "viewerId", value = "观众ID", required = false)
        private String viewerId;
        
        /**
         * 身份 guest：嘉宾 student：学员
         */
        @ApiModelProperty(name = "identity", value = "身份 guest：嘉宾 student：学员", required = false)
        private String identity;
        
        /**
         * 昵称
         */
        @ApiModelProperty(name = "nickname", value = "昵称", required = false)
        private String nickname;
        
        /**
         * 进入 rtc 的时间
         */
        @ApiModelProperty(name = "joinTime", value = "进入 rtc 的时间，13位毫秒时间戳", required = false)
        private Date joinTime;
        
        /**
         * 离开 rtc 的时间
         */
        @ApiModelProperty(name = "leaveTime", value = "离开 rtc 的时间，13位毫秒时间戳", required = false)
        private Date leaveTime;
    }
    
}