package net.polyv.live.v2.entity.channel.operate.account;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 修改角色信息响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("修改角色信息响应实体")
public class LiveUpdateAccountResponse {
    
    /**
     * 助教/嘉宾账号
     */
    @ApiModelProperty(name = "account", value = "助教/嘉宾账号", required = false)
    private String account;
    
    /**
     * 用户ID
     */
    @ApiModelProperty(name = "userId", value = "用户ID", required = false)
    private String userId;
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = false)
    private String channelId;
    
    /**
     * 角色密码
     */
    @ApiModelProperty(name = "passwd", value = "角色密码", required = false)
    private String passwd;
    
    /**
     * 角色名称
     */
    @ApiModelProperty(name = "nickname", value = "角色名称", required = false)
    private String nickname;
    
    /**
     * 角色流名，单独使用无效
     */
    @ApiModelProperty(name = "stream", value = "角色流名，单独使用无效", required = false)
    private String stream;
    
    /**
     * 角色状态 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "status", value = "角色状态 Y：开启 N：关闭", required = false)
    private String status;
    
    /**
     * 创建角色时间，13位毫秒级时间戳
     */
    @ApiModelProperty(name = "createdTime", value = "创建角色时间，13位毫秒级时间戳", required = false)
    private Date createdTime;
    
    /**
     * 角色最后修改时间，13位毫秒级时间戳
     */
    @ApiModelProperty(name = "lastModified", value = "角色最后修改时间，13位毫秒级时间戳", required = false)
    private Date lastModified;
    
    /**
     * 频道角色序号
     */
    @ApiModelProperty(name = "sort", value = "频道角色序号", required = false)
    private Integer sort;
    
    /**
     * 角色头像
     */
    @ApiModelProperty(name = "avatar", value = "角色头像", required = false)
    private String avatar;
    
    /**
     * 角色头衔
     */
    @ApiModelProperty(name = "actor", value = "角色头衔", required = false)
    private String actor;
    
    /**
     * 角色 Assistant：助教 Guest：嘉宾
     */
    @ApiModelProperty(name = "role", value = "角色 Assistant：助教 Guest：嘉宾", required = false)
    private String role;
    
    /**
     * 监播权限 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "monitorEnabled", value = "监播权限 Y：开启 N：关闭", required = false)
    private String monitorEnabled;
    
    /**
     * 翻页权限 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "pageTurnEnabled", value = "翻页权限 Y：开启 N：关闭", required = false)
    private String pageTurnEnabled;
    
    /**
     * 在线列表权限 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "chatListEnabled", value = "在线列表权限 Y：开启 N：关闭", required = false)
    private String chatListEnabled;
    
}