package net.polyv.live.v2.entity.channel.operate;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 批量修改频道皮肤请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("批量修改频道皮肤请求实体")
public class LiveUpdateChannelSkinRequest extends LiveCommonRequest {
    
    /**
     * 用英文逗号隔开的频道号，如：10000,100001 最多10000个
     */
    @ApiModelProperty(name = "channelIds", value = "用英文逗号隔开的频道号，如：10000,100001 最多10000个", required = true)
    @NotNull(message = "属性channelIds不能为空")
    private String channelIds;
    
    /**
     * 皮肤 black：时尚黑 red：喜庆红 blue：科技蓝 white：经典白 green：薄荷绿 golden：富贵金
     */
    @ApiModelProperty(name = "skin", value = "皮肤 black：时尚黑 red：喜庆红 blue：科技蓝 white：经典白 green：薄荷绿 golden：富贵金",
            required = true)
    @NotNull(message = "属性skin不能为空")
    private String skin;
    
}