package net.polyv.live.v2.entity.channel.operate;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 创建单个频道响应实体
 * @author: sadboy
 **/
@Data
@Accessors(chain = true)
@ApiModel("创建单个频道响应实体")
public class LiveChannelV2Response {
    
    /**
     * 频道ID
     */
    @ApiModelProperty(name = "channelId", value = "频道ID", required = false)
    private String channelId;
    
    /**
     * POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）
     */
    @ApiModelProperty(name = "userId", value = "POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）", required = false)
    private String userId;
    
    /**
     * 讲师登录密码，直播场景不是研讨会时不为null，长度6-16位
     */
    @ApiModelProperty(name = "channelPasswd", value = "讲师登录密码，直播场景不是研讨会时不为null，长度6-16位", required = false)
    private String channelPasswd;
    
    /**
     * 研讨会主持人密码，仅直播场景是研讨会时不为null，长度6-16位
     */
    @ApiModelProperty(name = "seminarHostPassword", value = "研讨会主持人密码，仅直播场景是研讨会时不为null，长度6-16位", required = false)
    private String seminarHostPassword;
    
    /**
     * 研讨会参会人密码，仅直播场景是研讨会时不为null，长度6-16位
     */
    @ApiModelProperty(name = "seminarAttendeePassword", value = "研讨会参会人密码，仅直播场景是研讨会时不为null，长度6-16位", required = false)
    private String seminarAttendeePassword;
    
    
    
}
