package net.polyv.live.v1.service.web.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;

import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.entity.web.interact.LiveChannelDonateRequest;
import net.polyv.live.v1.entity.web.interact.LiveChannelDonateResponse;
import net.polyv.live.v2.entity.channel.web.interact.cardpush.LiveCancelPushChannelCardPushRequest;
import net.polyv.live.v2.entity.channel.web.interact.cardpush.LiveCreateChannelCardPushRequest;
import net.polyv.live.v2.entity.channel.web.interact.cardpush.LiveCreateChannelCardPushResponse;
import net.polyv.live.v2.entity.channel.web.interact.cardpush.LiveDeleteChannelCardPushRequest;
import net.polyv.live.v2.entity.channel.web.interact.cardpush.LiveGetChannelCardPushRequest;
import net.polyv.live.v2.entity.channel.web.interact.cardpush.LiveGetChannelCardPushResponse;
import net.polyv.live.v2.entity.channel.web.interact.LiveGetChannelDonateRequest;
import net.polyv.live.v2.entity.channel.web.interact.LiveGetChannelDonateResponse;
import net.polyv.live.v1.entity.web.interact.LiveGetChannelWxShareRequest;
import net.polyv.live.v1.entity.web.interact.LiveGetChannelWxShareResponse;
import net.polyv.live.v1.entity.web.interact.LiveUpdateChannelCashRequest;
import net.polyv.live.v2.entity.channel.web.interact.LiveUpdateChannelDonateRequest;
import net.polyv.live.v1.entity.web.interact.LiveUpdateChannelGoodRequest;
import net.polyv.live.v1.entity.web.interact.LiveUpdateChannelWxShareRequest;
import net.polyv.live.v2.entity.channel.web.interact.cardpush.LivePushChannelCardPushRequest;
import net.polyv.live.v2.entity.channel.web.interact.cardpush.LiveUpdateChannelCardPushRequest;
import net.polyv.live.v2.entity.channel.web.interact.share.LiveGetChannelShareRequest;
import net.polyv.live.v2.entity.channel.web.interact.share.LiveGetChannelShareResponse;
import net.polyv.live.v2.entity.channel.web.interact.share.LiveUpdateChannelShareRequest;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.web.ILiveWebInteractService;
import net.polyv.live.v1.util.LiveSignUtil;

/**
 * @author: sadboy
 **/
public class LiveWebInteractServiceImpl extends LiveBaseService implements ILiveWebInteractService {
    
    /**
     * 设置道具打赏
     * API地址：https://dev.polyv.net/2018/liveproduct/l-api/szgkygg/ymhd/updategood/
     * @param liveUpdateChannelGoodRequest 设置道具打赏请求实体
     * @return 设置道具打赏返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateChannelGood(LiveUpdateChannelGoodRequest liveUpdateChannelGoodRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.GOOD_DONATE_SET_URL;
        Map<String, String> signMap = LiveSignUtil.getSignMap(liveUpdateChannelGoodRequest);
        signMap.put("channelId", String.valueOf(liveUpdateChannelGoodRequest.getChannelId()));
        this.postJsonBodyReturnOne(url, signMap, liveUpdateChannelGoodRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 设置现金打赏
     * API地址：https://dev.polyv.net/2018/liveproduct/l-api/szgkygg/ymhd/updatecash/
     * @param liveUpdateChannelCashRequest 设置现金打赏请求实体
     * @return 设置现金打赏返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateChannelCash(LiveUpdateChannelCashRequest liveUpdateChannelCashRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CASH_DONATE_SET_URL;
        Map<String, String> signMap = LiveSignUtil.getSignMap(liveUpdateChannelCashRequest);
        signMap.put("channelId", String.valueOf(liveUpdateChannelCashRequest.getChannelId()));
        this.postJsonBodyReturnOne(url, signMap, liveUpdateChannelCashRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 查询打赏设置
     * API地址：https://dev.polyv.net/2018/liveproduct/l-api/szgkygg/ymhd/donate-get/
     * @param liveChannelDonateRequest 查询打赏设置请求实体
     * @return 查询打赏设置返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveChannelDonateResponse getChannelDonate(LiveChannelDonateRequest liveChannelDonateRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHANNEL_DONATE_GET_URL;
        LiveChannelDonateResponse liveChannelDonateResponse = this.getReturnOne(url, liveChannelDonateRequest,
                LiveChannelDonateResponse.class);
        return liveChannelDonateResponse;
    }
    
    /**
     * 设置频道微信分享信息
     * API地址：https://dev.polyv.net/2018/liveproduct/l-api/szgkygg/ymhd/update-weixin-share/
     * @param liveUpdateChannelWxShareRequest 设置频道微信分享信息请求实体
     * @return 设置频道微信分享信息返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateChannelWxShare(LiveUpdateChannelWxShareRequest liveUpdateChannelWxShareRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.UPDATE_CHANNEL_WX_SHARE_URL;
        this.postFormBodyReturnOne(url, liveUpdateChannelWxShareRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 查询频道微信分享信息
     * API地址：https://dev.polyv.net/2018/liveproduct/l-api/szgkygg/ymhd/get-weixin-share/
     * @param liveGetChannelWxShareRequest 查询频道微信分享信息请求实体
     * @return 查询频道微信分享信息返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveGetChannelWxShareResponse getChannelWxShare(LiveGetChannelWxShareRequest liveGetChannelWxShareRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.GET_CHANNEL_WX_SHARE_URL;
        return this.getReturnOne(url, liveGetChannelWxShareRequest, LiveGetChannelWxShareResponse.class);
    }
    
    /**
     * 查询频道打赏设置
     * API地址：https://help.polyv.net/#/live/api/v4/user/template/getDonate
     * @param liveGetChannelDonateRequest 查询频道打赏设置请求实体
     * @return 查询频道打赏设置响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveGetChannelDonateResponse getChannelDonateV2(LiveGetChannelDonateRequest liveGetChannelDonateRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_CHANNEL_DONATE_URL;
        return this.getReturnOne(url, liveGetChannelDonateRequest, LiveGetChannelDonateResponse.class);
    }
    
    /**
     * 修改频道礼物打赏设置
     * API地址：https://help.polyv.net/#/live/api/v4/channel/donate/update
     * @param liveUpdateChannelDonateRequest 修改频道礼物打赏设置请求实体
     * @return 修改频道礼物打赏设置响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateChannelDonateV2(LiveUpdateChannelDonateRequest liveUpdateChannelDonateRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_UPDATE_CHANNEL_DONATE_URL;
        Map<String, String> signMap = LiveSignUtil.getSignMap(liveUpdateChannelDonateRequest);
        signMap.put("channelId", liveUpdateChannelDonateRequest.getChannelId());
        this.postJsonBodyReturnOne(url, signMap, liveUpdateChannelDonateRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 查询频道卡片推送
     * API地址：https://help.polyv.net/#/live/api/v4/channel/market/cardPush/get
     * @param liveGetChannelCardPushRequest 查询频道卡片推送请求实体
     * @return 查询频道卡片推送响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<LiveGetChannelCardPushResponse> getChannelCardPush(
            LiveGetChannelCardPushRequest liveGetChannelCardPushRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_CHANNEL_CARD_PUSH_URL;
        return this.getReturnList(url, liveGetChannelCardPushRequest, LiveGetChannelCardPushResponse.class);
    }
    
    /**
     * 创建频道卡片推送
     * API地址：https://help.polyv.net/#/live/api/v4/channel/market/cardPush/create
     * @param liveCreateChannelCardPushRequest 创建频道卡片推送请求实体
     * @return 创建频道卡片推送响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveCreateChannelCardPushResponse createChannelCardPush(
            LiveCreateChannelCardPushRequest liveCreateChannelCardPushRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_CREATE_CHANNEL_CARD_PUSH_URL;
        return this.getReturnOne(url, liveCreateChannelCardPushRequest, LiveCreateChannelCardPushResponse.class);
    }
    
    /**
     * 修改频道卡片推送
     * API地址：https://help.polyv.net/#/live/api/v4/channel/market/cardPush/update
     * @param liveUpdateChannelCardPushRequest 修改频道卡片推送请求实体
     * @return 修改频道卡片推送响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateChannelCardPush(LiveUpdateChannelCardPushRequest liveUpdateChannelCardPushRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_UPDATE_CHANNEL_CARD_PUSH_URL;
        Map<String, String> signMap = LiveSignUtil.getSignMap(liveUpdateChannelCardPushRequest);
        signMap.put("channelId", liveUpdateChannelCardPushRequest.getChannelId());
        signMap.put("cardPushId", String.valueOf(liveUpdateChannelCardPushRequest.getCardPushId()));
        this.postJsonBodyReturnOne(url, signMap, liveUpdateChannelCardPushRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 删除卡片推送
     * API地址：https://help.polyv.net/#/live/api/v4/channel/market/cardPush/delete
     * @param liveDeleteChannelCardPushRequest 删除卡片推送请求实体
     * @return 删除卡片推送响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean deleteChannelCardPush(LiveDeleteChannelCardPushRequest liveDeleteChannelCardPushRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_DELETE_CHANNEL_CARD_PUSH_URL;
        this.postFormBodyReturnOne(url, liveDeleteChannelCardPushRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 推送频道卡片
     * API地址：https://help.polyv.net/#/live/api/v4/channel/market/cardPush/push
     * @param livePushChannelCardPushRequest 推送频道卡片请求实体
     * @return 推送频道卡片响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean pushChannelCardPush(LivePushChannelCardPushRequest livePushChannelCardPushRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_PUSH_CHANNEL_CARD_PUSH_URL;
        this.postFormBodyReturnOne(url, livePushChannelCardPushRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 取消推送卡片
     * API地址：https://help.polyv.net/#/live/api/v4/channel/market/cardPush/cancelPush
     * @param liveCancelPushChannelCardPushRequest 取消推送卡片请求实体
     * @return 取消推送卡片响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean cancelPushChannelCardPush(LiveCancelPushChannelCardPushRequest liveCancelPushChannelCardPushRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_CANCEL_PUSH_CHANNEL_CARD_PUSH_URL;
        this.postFormBodyReturnOne(url, liveCancelPushChannelCardPushRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 查询频道微信分享信息
     * API地址：https://help.polyv.net/#/live/api/v4/channel/market/share/get
     * @param liveGetChannelShareRequest 查询频道微信分享信息请求实体
     * @return 查询频道微信分享信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveGetChannelShareResponse getChannelShare(LiveGetChannelShareRequest liveGetChannelShareRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_CHANNEL_SHARE_URL;
        return this.getReturnOne(url, liveGetChannelShareRequest, LiveGetChannelShareResponse.class);
    }
    
    /**
     * 修改频道微信分享信息
     * API地址：https://help.polyv.net/#/live/api/v4/channel/market/share/update
     * @param liveUpdateChannelShareRequest 修改频道微信分享信息请求实体
     * @return 修改频道微信分享信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateChannelShare(LiveUpdateChannelShareRequest liveUpdateChannelShareRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_UPDATE_CHANNEL_SHARE_URL;
        this.getReturnOne(url, liveUpdateChannelShareRequest, String.class);
        return Boolean.TRUE;
    }
    
}