package net.polyv.live.v1.service.channel;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeCreateRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeDeleteRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeListRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeListResponse;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeStatisticRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeStatisticResponse;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeUpdateRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveDistributeUpdateMasterSwitchRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveDistributeUpdateSwitchRequest;

/**
 * 云分发
 * @author: jiangyifan
 */
public interface ILiveChannelDistributeService {
    
    /**
     * 查询分发地址信息
     * API地址：https://help.polyv.net/#/live/api/v4/channel/distribute/list
     * @param liveChannelDistributeListRequest 查询分发地址信息请求实体
     * @return 查询分发地址信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveChannelDistributeListResponse listChannelDistribute(
            LiveChannelDistributeListRequest liveChannelDistributeListRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 批量添加分发地址
     * API地址：https://help.polyv.net/index.html#/live/api/v4/channel/distribute/create_batch
     * @param liveChannelDistributeCreateRequest 批量添加分发地址请求实体
     * @return 批量添加分发地址响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean createChannelDistribute(LiveChannelDistributeCreateRequest liveChannelDistributeCreateRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 批量修改分分发地址
     * API地址：https://help.polyv.net/index.html#/live/api/v4/channel/distribute/update_batch
     * @param liveChannelDistributeUpdateRequest 批量修改分分发地址请求实体
     * @return 批量修改分分发地址响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateChannelDistribute(LiveChannelDistributeUpdateRequest liveChannelDistributeUpdateRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 批量删除分发地址
     * API地址：https://help.polyv.net/index.html#/live/api/v4/channel/distribute/delete_batch
     * @param liveChannelDistributeDeleteRequest 批量删除分发地址请求实体
     * @return 批量删除分发地址响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean deleteChannelDistribute(LiveChannelDistributeDeleteRequest liveChannelDistributeDeleteRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 修改云分发频道总开关
     * API地址：https://help.polyv.net/index.html#/live/api/v4/channel/distribute/update-master-switch
     * @param liveDistributeUpdateMasterSwitchRequest 修改云分发频道总开关请求实体
     * @return 修改云分发频道总开关响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateMasterSwitch(LiveDistributeUpdateMasterSwitchRequest liveDistributeUpdateMasterSwitchRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 批量修改频道云分发开关
     * API地址：https://help.polyv.net/#/live/api/v4/channel/distribute/update-switch
     * @param liveDistributeUpdateSwitchRequest 批量修改频道云分发开关请求实体
     * @return 批量修改频道云分发开关响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateSwitch(LiveDistributeUpdateSwitchRequest liveDistributeUpdateSwitchRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询云分发数据信息
     * API地址：https://help.polyv.net/#/live/api/v4/channel/distribute/statistic
     * @param liveChannelDistributeStatisticRequest 查询云分发数据信息请求实体
     * @return 查询云分发数据信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<LiveChannelDistributeStatisticResponse> getDistributeStatistic(
            LiveChannelDistributeStatisticRequest liveChannelDistributeStatisticRequest)
            throws IOException, NoSuchAlgorithmException;
}
