package net.polyv.live.v1.entity.channel.advanced;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询频道实时字幕配置返回实体
 * @author sadboy
 */
@Data
@Accessors(chain = true)
@ApiModel("查询频道实时字幕配置返回实体")
public class LiveChannelRealtimeSubtitleResponse {
    
    /**
     * 实时字幕开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "realTimeSubtitleEnabled", value = "实时字幕开关，Y：开启，N：关闭", required = false)
    private String realTimeSubtitleEnabled;
    
    /**
     * 原声字幕语种，Chinese：中文；English：英文
     */
    @ApiModelProperty(name = "sourceLanguage", value = "原声字幕语种，Chinese：中文；English：英文", required = false)
    private String sourceLanguage;
    
    /**
     * 字幕翻译开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "subtitleTranslationEnabled", value = "字幕翻译开关，Y：开启，N：关闭", required = false)
    private String subtitleTranslationEnabled;
    
    /**
     * 字幕翻译语种，Chinese：中文；English：英文 等，可通过 new LiveChannelAdvancedServiceImpl().getLanguage() 查询对照
     */
    @ApiModelProperty(name = "translationLanguage", value = "字幕翻译语种，Chinese：中文；English：英文 等，可通过 new LiveChannelAdvancedServiceImpl().getLanguage() 查询对照", required = false)
    private String translationLanguage;
    
}
