package net.polyv.live.v2.entity.user.global;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改观看页默认模板设置请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改观看页默认模板设置请求实体")
public class LiveUpdatePageSettingRequest extends LiveCommonRequest {
    /**
     * 自动播放开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "autoPlayEnabled", value = "自动播放开关，Y：开启，N：关闭", required = false)
    private String autoPlayEnabled;
    
    /**
     * 弹幕开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "barrageEnabled", value = "弹幕开关，Y：开启，N：关闭", required = false)
    private String barrageEnabled;
    
    /**
     * 弹幕速度，340：缓慢，270：较慢，200：标准，130：较快，60：快速
     */
    @ApiModelProperty(name = "barrageSpeed", value = "弹幕速度，340：缓慢，270：较慢，200：标准，130：较快，60：快速", required = false)
    private String barrageSpeed;
    
    /**
     * 微信预约功能开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "bookingEnabled", value = "微信预约功能开关，Y：开启，N：关闭", required = false)
    private String bookingEnabled;
    
    /**
     * 观看页开关，Y：不显示观看页（仅允许集成SDK观看），N：显示观看页
     */
    @ApiModelProperty(name = "closePreviewEnabled", value = "观看页开关，Y：不显示观看页（仅允许集成SDK观看），N：显示观看页", required = false)
    private String closePreviewEnabled;
    
    /**
     * flash播放器开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "flashPlayerEnabled", value = "flash播放器开关，Y：开启，N：关闭", required = false)
    private String flashPlayerEnabled;
    
    /**
     * 禁止Firefox开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "forbidFirefoxEnabled", value = "禁止Firefox开关，Y：开启，N：关闭", required = false)
    private String forbidFirefoxEnabled;
    
    /**
     * 音视频切换开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "mobileAudioEnabled", value = "音视频切换开关，Y：开启，N：关闭", required = false)
    private String mobileAudioEnabled;
    
    /**
     * 观看次数移动端显示位置，player：播放器，desc：直播介绍
     */
    @ApiModelProperty(name = "mobilePvShowLocation", value = "观看次数移动端显示位置，player：播放器，desc：直播介绍", required = false)
    private String mobilePvShowLocation;
    
    /**
     * 移动观看页开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "mobileWatchEnabled", value = "移动观看页开关，Y：开启，N：关闭", required = false)
    private String mobileWatchEnabled;
    
    /**
     * 观看次数开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "pvShowEnabled", value = "观看次数开关，Y：开启，N：关闭", required = false)
    private String pvShowEnabled;
    
    /**
     * 防弹窗播放开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "recordingProtectEnabled", value = "防弹窗播放开关，Y：开启，N：关闭", required = false)
    private String recordingProtectEnabled;
    
    /**
     * 回放中显示“下一场次”倒计时 开关值，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "showCountdownEnabled", value = "回放中显示“下一场次”倒计时 开关值，Y：开启，N：关闭", required = false)
    private String showCountdownEnabled;
    
    /**
     * 允许观众切换h5及flash播放器，Y：允许，N：不允许；flash播放器开关为N时，该值不生效
     */
    @ApiModelProperty(name = "switchPlayerEnabled", value = "允许观众切换h5及flash播放器，Y：允许，N：不允许；flash播放器开关为N时，该值不生效",
            required = false)
    private String switchPlayerEnabled;
    
    /**
     * 观众实名认证开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "viewerVerificationEnabled", value = "观众实名认证开关，Y：开启，N：关闭", required = false)
    private String viewerVerificationEnabled;
    
    /**
     * 观众投诉开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "watchFeedbackEnabled", value = "观众投诉开关，Y：开启，N：关闭", required = false)
    private String watchFeedbackEnabled;
    
    /**
     * 观看页语言，zh_CN：中文，en：英文，follow_browser：跟随浏览器
     */
    @ApiModelProperty(name = "watchLangType", value = "观看页语言，zh_CN：中文，en：英文，follow_browser：跟随浏览器", required = false)
    private String watchLangType;
    
    /**
     * 观看页布局，ppt文档为主、video视频为主、only-video仅视频、followTeacher跟随讲师
     */
    @ApiModelProperty(name = "watchLayout", value = "观看页布局，ppt文档为主、video视频为主、only-video仅视频、followTeacher跟随讲师",
            required = false)
    private String watchLayout;
    
}