package net.polyv.live.v2.entity.channel.state;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 批量查询频道直播流信息请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("批量查询频道直播流信息请求实体")
public class LiveGetStreamsRequest extends LiveCommonRequest {
    /**
     * 直播中的频道号，多个频道用英文逗号分隔，最多100个
     */
    @ApiModelProperty(name = "channelIds", value = "直播中的频道号，多个频道用英文逗号分隔，最多100个", required = true)
    @NotNull(message = "属性channelIds不能为空")
    private String channelIds;
    
}