package net.polyv.live.v2.entity.channel.operate;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 获取频道关注公众号设置信息响应实体
 * @author liyongxuan
 */
@Data
@Accessors(chain = true)
@ApiModel("获取频道关注公众号设置信息响应实体")
public class LiveListChannelsFollowResponse {
    /**
     * 关注公众号设置列表【详见Detail参数描述】
     */
    @ApiModelProperty(name = "list", value = "关注公众号设置列表", required = false)
    private List<LiveListChannelsFollowResponse.ChannelsFollow> list;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("关注公众号设置信息")
    public static class ChannelsFollow {
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 关注公众号功能开关，开启Y、关闭N
         */
        @ApiModelProperty(name = "enabled", value = "关注公众号功能开关，开启Y、关闭N", required = false)
        private String enabled;
        
        /**
         * 主动弹窗开关，开启Y、关闭N
         */
        @ApiModelProperty(name = "autoShowEnabled", value = "主动弹窗开关，开启Y、关闭N", required = false)
        private String autoShowEnabled;
        
        /**
         * 二维码图片链接地址
         */
        @ApiModelProperty(name = "qrCodeUrl", value = "二维码图片链接地址", required = false)
        private String qrCodeUrl;
        
        /**
         * 入口文案
         */
        @ApiModelProperty(name = "entranceText", value = "入口文案", required = false)
        private String entranceText;
        
        /**
         * 弹窗提示文案
         */
        @ApiModelProperty(name = "tips", value = "弹窗提示文案", required = false)
        private String tips;
    }
    
}