package net.polyv.live.v2.entity.channel.account;

import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 查询所有频道的回放视频响应实体
 * @author liyongxuan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询所有频道的回放视频响应实体")
public class LiveListUserPlaybackResponse extends LivePageCommonResponse {
    /**
     * 响应成功时返回回放视频列表信息【详见data字段说明】
     */
    @ApiModelProperty(name = "contents", value = "响应成功时返回回放视频列表信息【详见data字段说明】")
    private List<LiveListUserPlaybackResponse.UserPlayback> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("直播回放视频信息")
    public static class UserPlayback {
        /**
         * 直播系统生成的id （视频库中的回放视频）
         */
        @ApiModelProperty(name = "videoId", value = "直播系统生成的id （视频库中的回放视频）", required = false)
        private String videoId;
        
        /**
         * 点播视频vid （视频库中的回放视频）
         */
        @ApiModelProperty(name = "videoPoolId", value = "点播视频vid （视频库中的回放视频）", required = false)
        private String videoPoolId;
        
        /**
         * POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）
         */
        @ApiModelProperty(name = "userId", value = "POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）", required = false)
        private String userId;
        
        /**
         * 回放视频对应的直播频道号
         */
        @ApiModelProperty(name = "channelId", value = "回放视频对应的直播频道号", required = false)
        private String channelId;
        
        /**
         * 视频标题
         */
        @ApiModelProperty(name = "title", value = "视频标题", required = false)
        private String title;
        
        /**
         * 视频首图
         */
        @ApiModelProperty(name = "firstImage", value = "视频首图", required = false)
        private String firstImage;
        
        /**
         * 视频长度，格式为HH:mm:ss
         */
        @ApiModelProperty(name = "duration", value = "视频长度，格式为HH:mm:ss", required = false)
        private String duration;
        
        /**
         * 默认视频的播放清晰度 1：流畅 2：高清 3：超清
         */
        @ApiModelProperty(name = "myBr", value = "默认视频的播放清晰度 1：流畅 2：高清 3：超清", required = false)
        private String myBr;
        
        /**
         * 访客信息收集id
         */
        @ApiModelProperty(name = "qid", value = "访客信息收集id", required = false)
        private String qid;
        
        /**
         * 视频加密状态，1表示为加密状态，0为非加密
         */
        @ApiModelProperty(name = "seed", value = "视频加密状态，1表示为加密状态，0为非加密", required = false)
        private Integer seed;
        
        /**
         * 关联点播视频的排序字段
         */
        @ApiModelProperty(name = "orderTime", value = "关联点播视频的排序字段", required = false)
        @JSONField(name = "ordertime")
        private Integer orderTime;
        
        /**
         * 添加为回放视频的日期
         */
        @ApiModelProperty(name = "createdTime", value = "添加为回放视频的日期", required = false)
        private Date createdTime;
        
        /**
         * 视频最后修改日期
         */
        @ApiModelProperty(name = "lastModified", value = "视频最后修改日期", required = false)
        private Date lastModified;
        
        /**
         * 排序值，值越大优先级越高
         */
        @ApiModelProperty(name = "rank", value = "排序值，值越大优先级越高", required = false)
        private Integer rank;
        
        /**
         * 是否为默认播放视频，值为Y/N Y：是 N：否
         */
        @ApiModelProperty(name = "asDefault", value = "是否为默认播放视频，值为Y/N Y：是 N：否", required = false)
        private String asDefault;
        
        /**
         * 视频播放地址，注：如果视频为加密视频，则此地址无法访问
         */
        @ApiModelProperty(name = "url", value = "视频播放地址，注：如果视频为加密视频，则此地址无法访问", required = false)
        private String url;
        
        /**
         * 用于PPT请求数据，与PPT直播的回放相关，普通直播回放值为null
         */
        @ApiModelProperty(name = "channelSessionId", value = "用于PPT请求数据，与PPT直播的回放相关，普通直播回放值为null", required = false)
        private String channelSessionId;
        
        /**
         * 关联点播视频的状态，60、61审核通过
         */
        @ApiModelProperty(name = "status", value = "关联点播视频的状态，60、61审核通过", required = false)
        private String status;
        
        /**
         * 视频地址
         */
        @ApiModelProperty(name = "fileUrl", value = "视频地址", required = false)
        private String fileUrl;
        
        /**
         * 回放视频转存前的暂存fileId
         */
        @ApiModelProperty(name = "fileId", value = "回放视频转存前的暂存fileId", required = false)
        private String fileId;
        
        /**
         * 直播开始时间
         */
        @ApiModelProperty(name = "startTime", value = "直播开始时间", required = false)
        @JSONField(format = "yyyyMMddHHmmss")
        private Date startTime;
        
        /**
         * 直播类型 alone：活动直播 ppt：三分屏 topclass：大班课 seminar：研讨会
         */
        @ApiModelProperty(name = "liveType", value = "直播类型 alone：活动直播 ppt：三分屏 topclass：大班课 seminar：研讨会", required =
                false)
        private String liveType;
        
        /**
         * 视频宽度
         */
        @ApiModelProperty(name = "width", value = "视频宽度", required = false)
        private Integer width;
        
        /**
         * 视频高度
         */
        @ApiModelProperty(name = "height", value = "视频高度", required = false)
        private Integer height;
        
        /**
         * 转存文件来源 manual：手动录制 auto：自动录制 merge：合并 clip：裁剪
         */
        @ApiModelProperty(name = "origin", value = "转存文件来源 manual：手动录制 auto：自动录制 merge：合并 clip：裁剪", required = false)
        private String origin;
        
        /**
         * 转存视频时设置的回调地址
         */
        @ApiModelProperty(name = "callbackUrl", value = "转存视频时设置的回调地址", required = false)
        private String callbackUrl;
        
        /**
         * 处理失败的次数
         */
        @ApiModelProperty(name = "errorCount", value = "处理失败的次数", required = false)
        private Integer errorCount;
        
        /**
         * 语言 zh_CN：中文 EN：英文
         */
        @ApiModelProperty(name = "lang", value = "语言 zh_CN：中文 EN：英文", required = false)
        private String lang;
        
        /**
         * 英文回放videoId
         */
        @ApiModelProperty(name = "videoIdEN", value = "英文回放videoId", required = false)
        private String videoIdEN;
        
        /**
         * 英文回放文件地址
         */
        @ApiModelProperty(name = "enFileUrl", value = "英文回放文件地址", required = false)
        private String enFileUrl;
        
        /**
         * 视频合并信息
         */
        @ApiModelProperty(name = "mergeInfo", value = "视频合并信息", required = false)
        @JSONField(name = "mergeinfo")
        private String mergeInfo;
        
        /**
         * 观看回放视频的地址
         */
        @ApiModelProperty(name = "watchUrl", value = "观看回放视频的地址", required = false)
        private String watchUrl;
    }
    
}