package net.polyv.live.v2.entity.channel.account;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 查询账号时间范围连麦使用量请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询账号时间范围连麦使用量请求实体")
public class LiveGetMicDurationRequest extends LiveCommonRequest {
    
    /**
     * 开始时间，13位毫秒级时间戳（仅支持到日期）
     */
    @ApiModelProperty(name = "startTime", value = "开始时间，13位毫秒级时间戳（仅支持到日期）", required = false)
    private Date startTime;
    
    /**
     * 结束时间，13位毫秒级时间戳（仅支持到日期）
     */
    @ApiModelProperty(name = "endTime", value = "结束时间，13位毫秒级时间戳（仅支持到日期）", required = false)
    private Date endTime;
    
}