package net.polyv.live.v1.service.channel.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.channel.ILiveChannelSessionService;
import net.polyv.live.v2.entity.channel.session.LiveSessionListRequest;
import net.polyv.live.v2.entity.channel.session.LiveSessionListResponse;

/**
 * 查询频道场次信息
 * @author: liyongxuan
 */
public class LiveChannelSessionServiceImpl extends LiveBaseService implements ILiveChannelSessionService {
    
    /**
     * 查询频道场次信息
     * API地址：https://help.polyv.net/#/live/api/channel/session/session_list
     * @param liveSessionListRequest 查询频道场次信息请求实体
     * @return 查询频道场次信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveSessionListResponse getSessionList(LiveSessionListRequest liveSessionListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_SESSION_LIST_URL;
        return this.getReturnOne(url, liveSessionListRequest, LiveSessionListResponse.class);
    }
}
