package net.polyv.live.v2.entity.user.children;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改子账号请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改子账号请求实体")
public class LiveUpdateUserChildrenRequest extends LiveCommonRequest {
    
    /**
     * 子账号登录邮箱
     */
    @ApiModelProperty(name = "childEmail", value = "子账号登录邮箱", required = true)
    @NotNull(message = "属性childEmail不能为空")
    private String childEmail;
    
    /**
     * 子账号用户名称，最大长度50个字符
     */
    @ApiModelProperty(name = "childName", value = "子账号用户名称，最大长度50个字符", required = false)
    private String childName;
    
    /**
     * 子账号密码，长度8~16位必须包含数字与字母
     */
    @ApiModelProperty(name = "password", value = "子账号密码，长度8~16位必须包含数字与字母", required = false)
    private String password;
    
    /**
     * 角色ID
     */
    @ApiModelProperty(name = "roleId", value = "角色ID", required = false)
    private Integer roleId;
    
    /**
     * 手机号码
     */
    @ApiModelProperty(name = "telephone", value = "手机号码", required = false)
    private String telephone;
    
    /**
     * 备注信息，最大长度100个字符
     */
    @ApiModelProperty(name = "description", value = "备注信息，最大长度100个字符", required = false)
    private String description;
    
}