package net.polyv.live.v2.entity.user.children;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 新增组织响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("新增组织响应实体")
public class LiveCreateOrganizationResponse {
    
    /**
     * 用户ID
     */
    @ApiModelProperty(name = "userId", value = "用户ID", required = false)
    private String userId;
    
    /**
     * 组织ID
     */
    @ApiModelProperty(name = "id", value = "组织ID", required = false)
    private Integer id;
    
    /**
     * 组织名称
     */
    @ApiModelProperty(name = "name", value = "组织名称", required = false)
    private String name;
    
    /**
     * 组织描述
     */
    @ApiModelProperty(name = "description", value = "组织描述", required = false)
    private String description;
    
    /**
     * 图标
     */
    @ApiModelProperty(name = "icon", value = "图标", required = false)
    private String icon;
    
    /**
     * 左节点
     */
    @ApiModelProperty(name = "lft", value = "左节点", required = false)
    private Integer lft;
    
    /**
     * 右节点
     */
    @ApiModelProperty(name = "rgt", value = "右节点", required = false)
    private Integer rgt;
    
    /**
     * 父级组织的左节点ID
     */
    @ApiModelProperty(name = "parentId", value = "父级组织的左节点ID", required = false)
    private Integer parentId;
    
}