package net.polyv.live.v2.entity.channel.statistics;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LivePageNumberCommonRequest;

/**
 * 查询邀请海报明细数据请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询邀请海报明细数据请求实体")
public class LiveGetInviteStatsRequest extends LivePageNumberCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 受邀开始时间
     */
    @ApiModelProperty(name = "startTime", value = "受邀开始时间", required = false)
    private Date startTime;
    
    /**
     * 受邀结束时间
     */
    @ApiModelProperty(name = "endTime", value = "受邀结束时间", required = false)
    private Date endTime;
    
}