package net.polyv.live.v2.entity.channel.playback;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 查询多个频道回放列表请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询多个频道回放列表请求实体")
public class LiveGetPlaybackListRequest extends LiveCommonRequest {
    
    /**
     * 用英文逗号隔开的频道号，如：10000,100001 最多100个
     */
    @ApiModelProperty(name = "channelIds", value = "用英文逗号隔开的频道号，如：10000,100001 最多100个", required = true)
    @NotNull(message = "属性channelIds不能为空")
    private String channelIds;
    
}