package net.polyv.live.v2.entity.channel.operate;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 创建并初始化频道
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("创建并初始化频道请求实体")
public class LiveChannelInitV2Request extends LiveCommonRequest {
    
    @ApiModelProperty(name = "basicSetting", value = "基础设置", required = true)
    @NotNull(message = "属性basicSetting不能为空")
    private LiveChannelInitV2Request.BasicSetting basicSetting;
    
    /**
     * 主要观看条件
     */
    @ApiModelProperty(name = "masterAuthSetting", value = "主要观看条件", required = false)
    private LiveChannelInitV2Request.MasterAuthSetting masterAuthSetting;
    
    /**
     * 角色设置，包括讲师、助教、嘉宾。 不传该字段，将按照默认模板设置角色信息。 传入该字段，不设置讲师，将按照默认模板设置讲师信息。 传入该字段，不设置助教、嘉宾将不创建。最多设置10个角色
     */
    @ApiModelProperty(name = "roles", value = "角色设置，包括讲师、助教、嘉宾。 不传该字段，将按照默认模板设置角色信息。 传入该字段，不设置讲师，将按照默认模板设置讲师信息。 " +
            "传入该字段，不设置助教、嘉宾将不创建。最多设置10个角色", required = false)
    private List<LiveChannelInitV2Request.Roles> roles;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("基础设置")
    public static class BasicSetting {
        
        /**
         * 直播名称，最大长度50
         */
        @ApiModelProperty(name = "name", value = "直播名称，最大长度50", required = true)
        @NotNull(message = "属性name不能为空")
        private String name;
        
        /**
         * 直播场景 (topclass-大班课 、 double-双师课（该场景需开通） 、 train-企业培训 、 seminar-研讨会 、 alone-活动营销)
         */
        @ApiModelProperty(name = "newScene", value = "直播场景 (topclass-大班课 、 double-双师课（该场景需开通） 、 train-企业培训 、 " +
                "seminar-研讨会 、 alone-活动营销)", required = true)
        @NotNull(message = "属性newScene不能为空")
        private String newScene;
        
        /**
         * 直播模板 (ppt-三分屏(横屏) 、 portrait_ppt-三分屏(竖屏) 、 alone-纯视频(横屏) 、portrait_alone-纯视频(竖屏) 、 topclass-纯视频-极速(横屏) 、
         * portrait_topclass-纯视频-极速(竖屏) 、 seminar-研讨会)
         * 直播场景为topclass时，该字段支持ppt、portrait_ppt、alone、portrait_alone、topclass、portrait_topclass
         * 直播场景为train或alone时，该字段支持ppt、portrait_ppt、alone、portrait_alone 直播场景为double时，该字段支持ppt、alone
         * 直播场景为seminar时，该字段支持seminar
         */
        @ApiModelProperty(name = "template", value = "直播模板 (ppt-三分屏(横屏) 、 portrait_ppt-三分屏(竖屏) 、 alone-纯视频(横屏) " +
                "、portrait_alone-纯视频(竖屏) 、 topclass-纯视频-极速(横屏) 、 portrait_topclass-纯视频-极速(竖屏) 、 seminar-研讨会) " +
                "直播场景为topclass时，该字段支持ppt、portrait_ppt、alone、portrait_alone、topclass、portrait_topclass " +
                "直播场景为train或alone时，该字段支持ppt、portrait_ppt、alone、portrait_alone 直播场景为double时，该字段支持ppt、alone " +
                "直播场景为seminar时，该字段支持seminar", required = false)
        private String template;
        
        /**
         * 讲师登录密码，直播场景不是研讨会时有效，长度6-16位，不传则由系统随机生成
         */
        @ApiModelProperty(name = "channelPasswd", value = "讲师登录密码，直播场景不是研讨会时有效，长度6-16位，不传则由系统随机生成", required = false)
        private String channelPasswd;
        
        /**
         * 研讨会主持人密码，仅直播场景是研讨会时有效，长度6-16位，不传则由系统随机生成
         */
        @ApiModelProperty(name = "seminarHostPassword", value = "研讨会主持人密码，仅直播场景是研讨会时有效，长度6-16位，不传则由系统随机生成", required
                = false)
        private String seminarHostPassword;
        
        /**
         * 研讨会参会人密码，仅直播场景是研讨会时有效，长度6-16位，不传则由系统随机生成
         */
        @ApiModelProperty(name = "seminarAttendeePassword", value = "研讨会参会人密码，仅直播场景是研讨会时有效，长度6-16位，不传则由系统随机生成",
                required = false)
        private String seminarAttendeePassword;
        
        /**
         * 分类ID
         */
        @ApiModelProperty(name = "categoryId", value = "分类ID", required = false)
        private Integer categoryId;
        
        /**
         * 直播开始时间
         */
        @ApiModelProperty(name = "startTime", value = "直播开始时间", required = false)
        private Date startTime;
        
        /**
         * 无延迟直播开关，Y：开启，N：关闭
         */
        @ApiModelProperty(name = "pureRtcEnabled", value = "无延迟直播开关，Y：开启，N：关闭", required = false)
        private String pureRtcEnabled;
        
        /**
         * 频道类型 发起转播：transmit 接收转播：receive 普通频道：normal
         */
        @ApiModelProperty(name = "type", value = "频道类型 发起转播：transmit 接收转播：receive 普通频道：normal", required = false)
        private String type;
        
        /**
         * 线上双师房间类型 transmit大房间、receive小房间
         */
        @ApiModelProperty(name = "doubleTeacherType", value = "线上双师房间类型 transmit大房间、receive小房间", required = false)
        private String doubleTeacherType;
        
        /**
         * 中英双语直播开关Y开、N关
         */
        @ApiModelProperty(name = "cnAndEnLiveEnabled", value = "中英双语直播开关Y开、N关", required = false)
        private String cnAndEnLiveEnabled;
        
        /**
         * 连麦人数限制，最多16人
         */
        @ApiModelProperty(name = "linkMicLimit", value = "连麦人数限制，最多16人", required = false)
        private Integer linkMicLimit;
        
        /**
         * 直播介绍，最多1024长度
         */
        @ApiModelProperty(name = "description", value = "直播介绍，最多1024长度", required = false)
        private String description;
        
        /**
         * 直播logo图片
         */
        @ApiModelProperty(name = "logoImg", value = "直播logo图片", required = false)
        private String logoImg;
        
        /**
         * 引导页封面图片
         */
        @ApiModelProperty(name = "splashImg", value = "引导页封面图片", required = false)
        private String splashImg;
        
        /**
         * 播放器封面图片，没有直播和回放的时候显示
         */
        @ApiModelProperty(name = "coverImg", value = "播放器封面图片，没有直播和回放的时候显示", required = false)
        private String coverImg;
        
        /**
         * 子账号邮箱，填写时频道会创建在该子账号下（子账号不能被删除或者禁用），暂无法通过接口获
         */
        @ApiModelProperty(name = "subAccount", value = "子账号邮箱，填写时频道会创建在该子账号下（子账号不能被删除或者禁用），暂无法通过接口获", required = false)
        private String subAccount;
    }
    
    @Data
    @Accessors(chain = true)
    @ApiModel("主要观看条件")
    public static class MasterAuthSetting {
        
        /**
         * 是否开启观看条件 Y：开启 N：关闭
         */
        @ApiModelProperty(name = "enabled", value = "是否开启观看条件 Y：开启 N：关闭", required = true)
        @NotNull(message = "属性enabled不能为空")
        private String enabled;
        
        /**
         * 观看条件类型 code：验证码观看 pay：付费观看 custom：自定义授权观看 external：外部授权观看 direct：独立授权观看
         */
        @ApiModelProperty(name = "authType", value = "观看条件类型 code：验证码观看 pay：付费观看 custom：自定义授权观看 external：外部授权观看 " +
                "direct：独立授权观看", required = false)
        private String authType;
        
        /**
         * authType为code时，设置参数，必填。观看验证码，长度不超过8位
         */
        @ApiModelProperty(name = "authCode", value = "authType为code时，设置参数，必填。观看验证码，长度不超过8位", required = false)
        private String authCode;
        
        /**
         * authType为code时，设置参数，非必填。欢迎标题，长度不超过20位，默认：欢迎观看本次直播
         */
        @ApiModelProperty(name = "codeAuthTips", value = "authType为code时，设置参数，非必填。欢迎标题，长度不超过20位，默认：欢迎观看本次直播",
                required = false)
        private String codeAuthTips;
        
        /**
         * authType为code时，设置参数，非必填。验证码提示文案，长度不超过30位，默认：扫描二维码获得验证码
         */
        @ApiModelProperty(name = "qCodeTips", value = "authType为code时，设置参数，非必填。验证码提示文案，长度不超过30位，默认：扫描二维码获得验证码",
                required = false)
        private String qCodeTips;
        
        /**
         * authType为code时，设置参数，非必填。二维码图片地址
         */
        @ApiModelProperty(name = "qCodeImg", value = "authType为code时，设置参数，非必填。二维码图片地址", required = false)
        private String qCodeImg;
        
        /**
         * 当authType为pay时，设置参数，必填。欢迎语标题，长度不超过20位
         */
        @ApiModelProperty(name = "payAuthTips", value = "当authType为pay时，设置参数，必填。欢迎语标题，长度不超过20位", required = true)
        @NotNull(message = "属性payAuthTips不能为空")
        private String payAuthTips;
        
        /**
         * 当authType为pay时，设置参数，必填。价格，单位为元
         */
        @ApiModelProperty(name = "price", value = "当authType为pay时，设置参数，必填。价格，单位为元", required = true)
        @NotNull(message = "属性price不能为空")
        private Float price;
        
        /**
         * 当authType为pay时，设置参数，非必填。付费有效截止日期
         */
        @ApiModelProperty(name = "watchEndTime", value = "当authType为pay时，设置参数，非必填。付费有效截止日期", required =
                false)
        private Date watchEndTime;
        
        /**
         * 当authType为pay时，设置参数，非必填。付费有效时长，单位天。当watchEndTime和validTimePeriod都为空时，表示付费永久有效
         */
        @ApiModelProperty(name = "validTimePeriod", value = "当authType为pay时，设置参数，非必填。付费有效时长，单位天。当watchEndTime" +
                "和validTimePeriod都为空时，表示付费永久有效", required = false)
        private Integer validTimePeriod;
        
        /**
         * 当authType为custom时，设置参数，必填。SecretKey，长度不超过10位
         */
        @ApiModelProperty(name = "customKey", value = "当authType为custom时，设置参数，必填。SecretKey，长度不超过10位", required = true)
        @NotNull(message = "属性customKey不能为空")
        private String customKey;
        
        /**
         * 当authType为custom时，设置参数，必填。自定义url
         */
        @ApiModelProperty(name = "customUri", value = "当authType为custom时，设置参数，必填。自定义url", required = true)
        @NotNull(message = "属性customUri不能为空")
        private String customUri;
        
        /**
         * 当authType为external时，设置参数，必填。SecretKey，长度不超过10位
         */
        @ApiModelProperty(name = "externalKey", value = "当authType为external时，设置参数，必填。SecretKey，长度不超过10位", required =
                true)
        @NotNull(message = "属性externalKey不能为空")
        private String externalKey;
        
        /**
         * 当authType为external时，设置参数，必填。自定义url
         */
        @ApiModelProperty(name = "externalUri", value = "当authType为external时，设置参数，必填。自定义url", required = true)
        @NotNull(message = "属性externalUri不能为空")
        private String externalUri;
        
        /**
         * 当authType为external时，设置参数，非必填。失败跳转地址
         */
        @ApiModelProperty(name = "externalRedirectUri", value = "当authType为external时，设置参数，非必填。失败跳转地址", required = false)
        private String externalRedirectUri;
        
        /**
         * 当authType为external时，设置参数，非必填。入口文本，默认为：登录观看
         */
        @ApiModelProperty(name = "externalEntryText", value = "当authType为external时，设置参数，非必填。入口文本，默认为：登录观看", required
                = false)
        private String externalEntryText;
        
        /**
         * 当authType为direct时，设置参数，必填。独立授权SecretKey，长度不超过10位
         */
        @ApiModelProperty(name = "directKey", value = "当authType为direct时，设置参数，必填。独立授权SecretKey，长度不超过10位", required =
                true)
        @NotNull(message = "属性directKey不能为空")
        private String directKey;
    }
    
    @Data
    @Accessors(chain = true)
    @ApiModel("角色设置")
    public static class Roles {
        
        /**
         * 角色类型 Teacher：讲师 Assistant：助教 Guest：嘉宾
         */
        @ApiModelProperty(name = "role", value = "角色类型 Teacher：讲师 Assistant：助教 Guest：嘉宾", required = true)
        @NotNull(message = "属性role不能为空")
        private String role;
        
        /**
         * 角色昵称
         */
        @ApiModelProperty(name = "nickName", value = "角色昵称", required = false)
        private String nickName;
        
        /**
         * 角色头衔
         */
        @ApiModelProperty(name = "actor", value = "角色头衔", required = false)
        private String actor;
        
        /**
         * 角色密码，密码长度6-16位，必须包含数字和英文
         */
        @ApiModelProperty(name = "passwd", value = "角色密码，密码长度6-16位，必须包含数字和英文", required = false)
        private String passwd;
        
        /**
         * 角色头像图片地址，需包含协议
         */
        @ApiModelProperty(name = "avatar", value = "角色头像图片地址，需包含协议", required = false)
        private String avatar;
    }
    
}
