package net.polyv.live.v1.service.channel.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.entity.channel.product.LiveAddProductRequest;
import net.polyv.live.v1.entity.channel.product.LiveAddProductResponse;
import net.polyv.live.v1.entity.channel.product.LiveDeleteChannelProductRequest;
import net.polyv.live.v1.entity.channel.product.LiveGetProductEnabledRequest;
import net.polyv.live.v1.entity.channel.product.LiveGetProductEnabledResponse;
import net.polyv.live.v1.entity.channel.product.LiveGetProductListRequest;
import net.polyv.live.v1.entity.channel.product.LiveGetProductListResponse;
import net.polyv.live.v1.entity.channel.product.LivePushProductRequest;
import net.polyv.live.v1.entity.channel.product.LiveShelfChannelProductRequest;
import net.polyv.live.v1.entity.channel.product.LiveSortChannelProductRequest;
import net.polyv.live.v1.entity.channel.product.LiveUpdateProductEnabledRequest;
import net.polyv.live.v1.entity.channel.product.LiveUpdateProductRequest;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.channel.LiveChannelProductService;
import net.polyv.live.v1.util.LiveSignUtil;

/**
 * 直播商品库实现类
 * @author: jiangyifan
 */
public class LiveChannelProductServiceImpl extends LiveBaseService implements LiveChannelProductService {
    
    /**
     * 添加频道商品库商品
     * API地址：https://help.polyv.net/#/live/api/channel/operate/add_channel_product
     * @param liveAddProductRequest 添加频道商品库商品请求实体
     * @return 添加频道商品响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveAddProductResponse addChannelProduct(LiveAddProductRequest liveAddProductRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.ADD_CHANNEL_PRODUCT;
        Map<String, String> signMap = LiveSignUtil.getSignMap(liveAddProductRequest);
        signMap.put("channelId", liveAddProductRequest.getChannelId());
        return this.postJsonBodyReturnOne(url, signMap, liveAddProductRequest, LiveAddProductResponse.class);
    }
    
    /**
     * 查询频道商品库开关状态
     * API地址：https://help.polyv.net/#/live/api/channel/operate/get_channel_product_enabled
     * @param liveGetProductEnabledRequest 查询频道商品库开关状态请求实体
     * @return 查询频道商品库开关状态实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveGetProductEnabledResponse getChannelProductEnabled(
            LiveGetProductEnabledRequest liveGetProductEnabledRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHANNEL_PRODUCT_GET_ENABLED;
        return this.getReturnOne(url, liveGetProductEnabledRequest, LiveGetProductEnabledResponse.class);
    }
    
    /**
     * 查询频道商品列表
     * API地址：https://help.polyv.net/#/live/api/channel/operate/get_channel_product_list
     * @param liveGetProductListRequest 查询频道商品列表请求实体
     * @return 查询频道商品列表响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveGetProductListResponse getChannelProductList(LiveGetProductListRequest liveGetProductListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHANNEL_PRODUCT_GET_LIST;
        return this.getReturnOne(url, liveGetProductListRequest, LiveGetProductListResponse.class);
    }
    
    /**
     * 推送频道商品库商品
     * API地址：https://help.polyv.net/#/live/api/channel/operate/push_channel_product
     * @param livePushProductRequest 推送频道商品库商品请求实体
     * @return 推送频道商品库商品响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean pushChannelProduct(LivePushProductRequest livePushProductRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHANNEL_PRODUCT_PUSH;
        this.postFormBodyReturnOne(url, livePushProductRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 修改频道商品库开关状态
     * API地址：https://help.polyv.net/#/live/api/channel/operate/update_channel_product_enabled
     * @param liveUpdateProductEnabledRequest 修改频道商品库开关状态请求实体
     * @return 修改频道商品库开关状态响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateChannelProductEnabled(LiveUpdateProductEnabledRequest liveUpdateProductEnabledRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHANNEL_PRODUCT_UPDATE_ENABLED;
        this.postFormBodyReturnOne(url, liveUpdateProductEnabledRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 修改频道商品库上下架状态
     * API地址：https://help.polyv.net/#/live/api/channel/operate/shelf_channel_product
     * @param liveShelfChannelProductRequest 修改频道商品库上下架状态请求实体
     * @return 修改频道商品库上下架状态响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean shelfChannelProduct(LiveShelfChannelProductRequest liveShelfChannelProductRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.SHELF_CHANNEL_PRODUCT;
        this.postFormBodyReturnOne(url, liveShelfChannelProductRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 修改频道商品库列表顺序
     * API地址：https://help.polyv.net/#/live/api/channel/operate/sort_channel_product
     * @param liveSortChannelProductRequest 修改频道商品库列表顺序请求实体
     * @return 修改频道商品库列表顺序响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean sortChannelProduct(LiveSortChannelProductRequest liveSortChannelProductRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.SORT_CHANNEL_PRODUCT;
        this.postFormBodyReturnOne(url, liveSortChannelProductRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 删除频道商品
     * API地址：https://help.polyv.net/#/live/api/channel/operate/delete_channel_product
     * @param liveDeleteChannelProductRequest 删除频道商品请求实体
     * @return 删除频道商品响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean deleteChannelProduct(LiveDeleteChannelProductRequest liveDeleteChannelProductRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.DELETE_CHANNEL_PRODUCT;
        this.postFormBodyReturnOne(url, liveDeleteChannelProductRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 修改频道商品信息
     * API地址：https://help.polyv.net/#/live/api/channel/operate/update_channel_product
     * @param liveUpdateProductRequest 修改频道商品信息请求实体
     * @return 修改频道商品信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateChannelProduct(LiveUpdateProductRequest liveUpdateProductRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHANNEL_PRODUCT_UPDATE;
        Map<String, String> signMap = LiveSignUtil.getSignMap(liveUpdateProductRequest);
        signMap.put("channelId", liveUpdateProductRequest.getChannelId());
        this.postJsonBodyReturnOne(url, signMap, liveUpdateProductRequest, String.class);
        return Boolean.TRUE;
    }
}
