package net.polyv.live.v1.entity.channel.viewdata;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询频道多场次概览统计数据响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询频道多场次概览统计数据响应实体")
public class LiveGetSessionStatsResponse {
    
    /**
     * 直播间内多场次的观看数据列表
     */
    @ApiModelProperty(name = "list", value = "直播间内多场次的观看数据列表", required = false)
    private List<LiveGetSessionStatsResponse.ChannelSessionStats> list;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("场次的观看数据")
    public static class ChannelSessionStats {
        
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 场次ID
         */
        @ApiModelProperty(name = "sessionId", value = "场次ID", required = false)
        private String sessionId;
        
        /**
         * 场次名称
         */
        @ApiModelProperty(name = "name", value = "场次名称", required = false)
        private String name;
        
        /**
         * 场次开始时间
         */
        @ApiModelProperty(name = "startTime", value = "场次开始时间", required = false)
        private Date startTime;
        
        /**
         * 场次结束时间
         */
        @ApiModelProperty(name = "endTime", value = "场次结束时间", required = false)
        private Date endTime;
        
        /**
         * 直播时长，单位秒
         */
        @ApiModelProperty(name = "duration", value = "直播时长，单位秒", required = false)
        private Integer duration;
        
        /**
         * 直播观看用户数
         */
        @ApiModelProperty(name = "liveUV", value = "直播观看用户数", required = false)
        private Integer liveUV;
        
        /**
         * 直播观看次数
         */
        @ApiModelProperty(name = "livePV", value = "直播观看次数", required = false)
        private Integer livePV;
        
        /**
         * 回放观看用户数
         */
        @ApiModelProperty(name = "playbackUV", value = "回放观看用户数", required = false)
        private Integer playbackUV;
        
        /**
         * 回放观看次数
         */
        @ApiModelProperty(name = "playbackPV", value = "回放观看次数", required = false)
        private Integer playbackPV;
        
        /**
         * 观看直播总时长，单位秒
         */
        @ApiModelProperty(name = "totalPlayDuration", value = "观看直播总时长，单位秒", required = false)
        private Integer totalPlayDuration;
        
        /**
         * 观看回放总时长，单位秒
         */
        @ApiModelProperty(name = "totalPlaybackDuration", value = "观看回放总时长，单位秒", required = false)
        private Integer totalPlaybackDuration;
    }
}