package net.polyv.live.v1.entity.channel.operate;

import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询报名观看记录响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询报名观看记录响应实体")
public class LiveGetEnrollListResponse {
    /**
     * 频道报名审核开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "auditEnabled", value = "频道报名审核开关 Y：开启 N：关闭", required = false)
    private String auditEnabled;
    
    /**
     * 报名观看记录【详见list字段描述】
     */
    @ApiModelProperty(name = "list", value = "报名观看记录", required = false)
    private List<LiveGetEnrollListResponse.LiveEnrollList> list;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("报名观看记录")
    public static class LiveEnrollList {
        
        /**
         * 观众ID
         */
        @ApiModelProperty(name = "viewerId", value = "观众ID", required = false)
        private String viewerId;
        
        /**
         * 手机号
         */
        @ApiModelProperty(name = "mobile", value = "手机号", required = false)
        private String mobile;
        
        /**
         * 报名时间
         */
        @ApiModelProperty(name = "createTime", value = "报名时间", required = false)
        @JSONField(format = "yyyy-MM-dd HH:mm:ss")
        private Date createTime;
        
        /**
         * 是否已观看 Y：是 N：否
         */
        @ApiModelProperty(name = "hasWatched", value = "是否已观看 Y：是 N：否", required = false)
        private String hasWatched;
        
        /**
         * 推广渠道ID
         */
        @ApiModelProperty(name = "promoteId", value = "推广渠道ID", required = false)
        private String promoteId;
        
        /**
         * 推广渠道名称
         */
        @ApiModelProperty(name = "promoteName", value = "推广渠道名称", required = false)
        private String promoteName;
        
        /**
         * 审核结果 W：未审核 P：已通过 F：已拒绝
         */
        @ApiModelProperty(name = "auditStatus", value = "审核结果 W：未审核 P：已通过 F：已拒绝", required = false)
        private String auditStatus;
        
        /**
         * 报名信息【详见fields字段描述】
         */
        @ApiModelProperty(name = "fields", value = "报名信息", required = false)
        private List<LiveEnrollFields> fields;
    }
    
    @Data
    @Accessors(chain = true)
    @ApiModel("报名信息")
    public static class LiveEnrollFields {
        /**
         * 报名信息名称
         */
        @ApiModelProperty(name = "name", value = "报名信息名称", required = false)
        private String name;
        
        /**
         * 报名信息值
         */
        @ApiModelProperty(name = "value", value = "报名信息值", required = false)
        private String value;
    }
}