package net.polyv.live.v2.entity.user.global;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询页脚设置响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询页脚设置响应实体")
public class LiveGetFooterSettingResponse {
    
    /**
     * POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）
     */
    @ApiModelProperty(name = "userId", value = "POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）", required = false)
    private String userId;
    
    /**
     * 是否开启页脚 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "showFooterEnabled", value = "是否开启页脚 Y：开启 N：关闭", required = false)
    private String showFooterEnabled;
    
    /**
     * 页脚文案
     */
    @ApiModelProperty(name = "footerText", value = "页脚文案", required = false)
    private String footerText;
    
    /**
     * 页脚链接协议头
     */
    @ApiModelProperty(name = "footTextLinkProtocol", value = "页脚链接协议头", required = false)
    private String footTextLinkProtocol;
    
    /**
     * 页脚链接地址
     */
    @ApiModelProperty(name = "footTextLinkUrl", value = "页脚链接地址", required = false)
    private String footTextLinkUrl;
    
}