package net.polyv.live.v2.entity.user.finance;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

@Data
@Accessors(chain = true)
@ApiModel("查询频道连麦详情数据响应实体")
@EqualsAndHashCode(callSuper = true)
public class LiveGetBillUseDetailResponse extends LivePageCommonResponse {
    
    /**
     * 账单使用详情
     */
    @ApiModelProperty(name = "contents", value = "账单使用详情", required = false)
    private List<BillUseDetail> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("账单使用详情")
    public static class BillUseDetail {
        
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 用量
         */
        @ApiModelProperty(name = "consumed", value = "用量", required = false)
        private Integer consumed;
        
        /**
         * 用量单位
         */
        @ApiModelProperty(name = "consumeUnit", value = "用量单位", required = false)
        private String consumeUnit;
        
        /**
         * 结束时间
         */
        @ApiModelProperty(name = "endTime", value = "结束时间", required = false)
        private Date endTime;
        
        /**
         * 计费项，<br/>duration：直播分钟数；<br/>concurrence：直播并发；<br/>mic_duration：连麦分钟数；<br/>ppt_anim：PPT动效转码；<br/>guide_duration：导播台；<br/>ppt_composite：重制课件；<br/>distribute：
         */
        @ApiModelProperty(name = "itemCategory", value =
                "计费项，<br/>duration：直播分钟数；<br/>concurrence：直播并发；<br/>mic_duration：连麦分钟数；<br/>" +
                        "ppt_anim：PPT动效转码；<br/>guide_duration：导播台；<br/>ppt_composite：重制课件；<br/>distribute：云分发",
                required = false)
        private String itemCategory;
        
        /**
         * 项目明细，如：国内观看时长、1v1~6 连麦等
         */
        @ApiModelProperty(name = "itemName", value = "项目明细，如：国内观看时长、1v1~6 连麦等", required = false)
        private String itemName;
        
        /**
         * 产品，如：live
         */
        @ApiModelProperty(name = "production", value = "产品，如：live", required = false)
        private String production;
        
        /**
         * 记录id
         */
        @ApiModelProperty(name = "recordId", value = "记录id", required = false)
        private String recordId;
        
        /**
         * 备注
         */
        @ApiModelProperty(name = "remark", value = "备注", required = false)
        private String remark;
        
        /**
         * 开始时间
         */
        @ApiModelProperty(name = "startTime", value = "开始时间", required = false)
        private Date startTime;
        
        /**
         * 出账日期
         */
        @ApiModelProperty(name = "statDate", value = "出账日期", required = false)
        private String statDate;
        
    }
    
}
