package net.polyv.live.v2.entity.user.finance;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LivePageNumberCommonRequest;

/**
 * 查询用户账单使用详情数据请求实体
 * @author sadboy
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询用户账单使用详情数据请求实体")
public class LiveGetBillUseDetailRequest extends LivePageNumberCommonRequest {
    
    /**
     * 计费项，必填;duration：直播分钟数；concurrence：直播并发；mic_duration：连麦分钟数；ppt_anim：PPT动效转码；guide_duration：导播台；ppt_composite
     * ：重制课件；distribute：云分发；aiPPTVideoEnabled：智能制课（不含数字人）；aiPPTVideoWithDigital：智能制课（含数字人）；aiAssistantEnabled：AI
     * 助手答疑；aiSmartClipEnabled：智能裁剪
     */
    @ApiModelProperty(name = "itemCategory", value =
            "计费项，必填;<br/>duration：直播分钟数；<br/>concurrence：直播并发；<br/>mic_duration：连麦分钟数；<br/>ppt_anim：PPT动效转码；<br" +
                    "/>guide_duration：导播台；<br/>ppt_composite\n" +
                    "：重制课件；<br/>distribute：云分发；<br/>aiPPTVideoEnabled：智能制课（不含数字人）；<br/>aiPPTVideoWithDigital" +
                    "：智能制课（含数字人）；<br/>aiAssistantEnabled：AI" +
                    "助手答疑；<br/>aiSmartClipEnabled：智能裁剪", required = true)
    @NotNull(message = "属性itemCategory不能为空")
    private String itemCategory;
    
    /**
     * 开始日期，必填，格式：yyyy-MM-dd，不允许跨月查询
     */
    @ApiModelProperty(name = "startDate", value = "开始日期，必填，格式：yyyy-MM-dd，不允许跨月查询", required = true)
    @JSONField(format = "yyyy-MM-dd")
    private Date startDate;
    
    /**
     * 结束日期，必填，格式：yyyy-MM-dd，不允许跨月查询
     */
    @ApiModelProperty(name = "endDate", value = "结束日期，必填，格式：yyyy-MM-dd，不允许跨月查询", required = true)
    @JSONField(format = "yyyy-MM-dd")
    private Date endDate;
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = false)
    private String channelId;
    
}
