package net.polyv.live.v2.entity.chat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询频道虚拟人数设置响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询频道虚拟人数设置响应实体")
public class LiveGetRobotSettingResponse {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = false)
    private String channelId;
    
    /**
     * 聊天室显示虚拟人数
     */
    @ApiModelProperty(name = "robotNumber", value = "聊天室显示虚拟人数", required = false)
    private Integer robotNumber;
    
    /**
     * 人数显示模式 timely：立即生效 fixed_time：分时生效
     */
    @ApiModelProperty(name = "addRobotModel", value = "人数显示模式 timely：立即生效 fixed_time：分时生效", required = false)
    private String addRobotModel;
    
    /**
     * 虚拟预约人数
     */
    @ApiModelProperty(name = "virtualBookingNumber", value = "虚拟预约人数", required = false)
    private Integer virtualBookingNumber;
    
    /**
     * 生效时间，单位毫秒
     */
    @ApiModelProperty(name = "changeTime", value = "生效时间，单位毫秒", required = false)
    private Integer changeTime;
    
    /**
     * 距离下次可设置时间，单位毫秒
     */
    @ApiModelProperty(name = "leftTime", value = "距离下次可设置时间，单位毫秒", required = false)
    private Long leftTime;
    
}