package net.polyv.live.v2.entity.channel.web.interact;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 查询多个频道抽奖记录响应实体
 * @author liyongxuan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询多个频道抽奖记录响应实体")
public class LiveListChannelsLotteryResponse extends LivePageCommonResponse {
    
    /**
     * 抽奖记录列表
     */
    @ApiModelProperty(name = "contents", value = "抽奖记录列表 ", required = false)
    private List<LotteryListModel> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("抽奖记录的分页结果 ")
    public static class LotteryListModel {
        /**
         * 抽奖场次ID
         */
        @ApiModelProperty(name = "lotteryId", value = "抽奖场次ID", required = false)
        private String lotteryId;
        
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 抽奖时的直播场次ID
         */
        @ApiModelProperty(name = "sessionId", value = "抽奖时的直播场次ID", required = false)
        private String sessionId;
        
        /**
         * 账号userId
         */
        @ApiModelProperty(name = "userId", value = "账号userId", required = false)
        private String userId;
        
        /**
         * 抽奖范围 all：所有观众 notWinning：当场直播未中奖用户 signed：已签到用户 actor：头衔 questionnaire：已填问卷用户
         */
        @ApiModelProperty(name = "lotteryRange", value = "抽奖范围 all：所有观众 notWinning：当场直播未中奖用户 signed：已签到用户 actor：头衔 " +
                "questionnaire：已填问卷用户", required = false)
        private String lotteryRange;
        
        /**
         * 抽奖范围为按头衔抽奖时的头衔
         */
        @ApiModelProperty(name = "actor", value = "抽奖范围为按头衔抽奖时的头衔", required = false)
        private String actor;
        
        /**
         * 奖品名称
         */
        @ApiModelProperty(name = "prize", value = "奖品名称", required = false)
        private String prize;
        
        /**
         * 预设中奖人数
         */
        @ApiModelProperty(name = "amount", value = "预设中奖人数", required = false)
        private Integer amount;
        
        /**
         * 预设中奖观众ID，多个ID 用英文逗号分开
         */
        @ApiModelProperty(name = "preset", value = "预设中奖观众ID，多个ID 用英文逗号分开", required = false)
        private String preset;
        
        /**
         * 抽奖时间
         */
        @ApiModelProperty(name = "createdTime", value = "抽奖时间", required = false)
        private Date createdTime;
        
        /**
         * 最后修改时间
         */
        @ApiModelProperty(name = "lastModified", value = "最后修改时间", required = false)
        private Date lastModified;
        
        /**
         * 实际中奖人数
         */
        @ApiModelProperty(name = "winnerCount", value = "实际中奖人数", required = false)
        private String winnerCount;
        
        /**
         * json 格式的字符串,表示抽奖的额外拓展信息，对应模型类：LotteryListModelExt字段说明
         */
        @ApiModelProperty(name = "ext", value = "json 格式的字符串,表示抽奖的额外拓展信息，对应模型类：LotteryListModelExt字段说明", required =
                false)
        private String ext;
    }
    
}