package net.polyv.live.v2.entity.channel.viewdata;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 分页查询账号观看记录响应实体
 * @author sadboy
 */
@Data
@Accessors(chain = true)
@ApiModel("分页查询账号观看记录响应实体")
public class LiveListAccountViewlogResponse extends LivePageCommonResponse {
    
    /**
     * 查询的结果列表
     */
    @ApiModelProperty(name = "contents", value = "查询的结果列表", required = false)
    private List<LiveListAccountViewlogResponse.ViewlogDetail> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("查询的结果列表")
    public static class ViewlogDetail {
        
        /**
         * 平均观看时长
         */
        @ApiModelProperty(name = "avgDuration", value = "平均观看时长", required = false)
        private String avgDuration;
        
        /**
         * 昵称
         */
        @ApiModelProperty(name = "nick", value = "昵称", required = false)
        private String nick;
        
        /**
         * 总观看时长
         */
        @ApiModelProperty(name = "totalDuration", value = "总观看时长", required = false)
        private String totalDuration;
        
        /**
         * 观看次数
         */
        @ApiModelProperty(name = "viewCount", value = "观看次数", required = false)
        private Integer viewCount;
        
        /**
         * 用户Id
         */
        @ApiModelProperty(name = "viewerId", value = "用户Id", required = false)
        private String viewerId;
        
        /**
         * 自定义参数param4
         */
        @ApiModelProperty(name = "param4", value = "自定义参数param4", required = false)
        private String param4;
        
        /**
         * 自定义参数param5
         */
        @ApiModelProperty(name = "param5", value = "自定义参数param5", required = false)
        private String param5;
        
    }
    
}
